/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlShouldBeInGroupByInspection
extends SqlInspectionBase {
    private static boolean inAggregateFunctionCall(SqlReferenceExpression ref) {
        SqlFunctionCallExpression call = SqlShouldBeInGroupByInspection.getFunctionCallParent((PsiElement)ref);
        while (call != null) {
            if (SqlShouldBeInGroupByInspection.isAggregate(call)) {
                return true;
            }
            call = SqlShouldBeInGroupByInspection.getFunctionCallParent((PsiElement)call);
        }
        return false;
    }

    @Nullable
    private static SqlFunctionCallExpression getFunctionCallParent(@Nullable PsiElement o) {
        return (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
    }

    private static boolean isAggregate(@Nullable SqlFunctionCallExpression call) {
        if (call == null) {
            return false;
        }
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)call.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            return false;
        }
        return "true".equals(definition.getDialectAttribute("analytic")) || "true".equals(definition.getDialectAttribute("aggregate"));
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "createAnnotationVisitor"));
        }
        DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        if (!familyId.isMicrosoft() && !familyId.isOracle()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlQueryExpression(o);
                for (final SqlReferenceExpression ref : SqlShouldBeInGroupByInspection.getNonAggregateColumnRefs(o)) {
                    JBIterable names = SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o).transform((Function)new Function<PsiElement, CharSequence>(){

                        public CharSequence fun(PsiElement element) {
                            return SqlShouldBeInGroupByInspection.getResolvedColumnName(myDialect.getDatabaseDialect(), ref, element);
                        }
                    });
                    int size = names.size();
                    if (size == 0) continue;
                    String strNames = StringUtil.join((Iterable)names, (String)", ");
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref, SqlMessages.message(size == 1 ? "column.should.be.in.group.by" : "columns.should.be.in.group.by", strNames), (LocalQuickFix)new AddToGroupByQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    @NotNull
    private static JBIterable<SqlReferenceExpression> getNonAggregateColumnRefs(@NotNull SqlQueryExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getNonAggregateColumnRefs"));
        }
        SqlSelectClause selectClause = o.getSelectClause();
        if (selectClause == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getNonAggregateColumnRefs"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)selectClause).expand(Conditions.notInstanceOf(SqlReferenceExpression.class))).filter(SqlReferenceExpression.class).filter((Condition)new Condition<SqlReferenceExpression>(){

            public boolean value(SqlReferenceExpression e) {
                return e.getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && !SqlShouldBeInGroupByInspection.inAggregateFunctionCall(e);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getNonAggregateColumnRefs"));
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, @Nullable SqlQueryExpression o) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvesNotInGroupBy"));
        }
        JBIterable<PsiElement> jBIterable = SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o == null || o.getTableExpression() == null ? null : o.getTableExpression().getGroupByClause());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvesNotInGroupBy"));
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, final @Nullable SqlGroupByClause groupByClause) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvesNotInGroupBy"));
        }
        if (groupByClause == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvesNotInGroupBy"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(DbSqlUtil.resolveToColumnList(ref)).filter((Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)groupByClause)).findFirst() == null;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvesNotInGroupBy"));
        }
        return jBIterable;
    }

    @NotNull
    private static String getResolvedColumnName(@NotNull DatabaseDialectEx dialect, @NotNull SqlReferenceExpression ref, @NotNull PsiElement resolved) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null || ref.getReference().isReferenceTo(resolved)) {
            String string = ref.getReference().getCanonicalText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
            }
            return string;
        }
        for (int i = 0; i < type.getColumnCount(); ++i) {
            if (type.getColumnElement(i) != resolved) continue;
            DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(ref.getProject()).withDialect(dialect);
            String name = StringUtil.notNullize((String)type.getColumnName(i));
            String typeAlias = type.getColumnTypeAlias(i);
            if (typeAlias == null) {
                String string = ref.getReference().getCanonicalText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
                }
                return string;
            }
            builder.columnRef(typeAlias).symbol(".").columnRef(name);
            String string = builder.getStatement();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
            }
            return string;
        }
        String string = ref.getReference().getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "getResolvedColumnName"));
        }
        return string;
    }

    @NotNull
    private static Iterable<CharSequence> nameElements(@NotNull SqlTableExpression tableExpression, final @NotNull SqlReferenceExpression ref, @NotNull JBIterable<PsiElement> elements) {
        if (tableExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableExpression", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "nameElements"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "nameElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "nameElements"));
        }
        final DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref).getDatabaseDialect();
        SqlTableType partType = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (partType != null) {
            List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(ref.getProject(), dialect, partType, tableExpression.getSqlType());
            ArrayList filtered = ContainerUtil.newArrayListWithCapacity((int)elements.size());
            Iterator it = elements.iterator();
            PsiElement cur = (PsiElement)it.next();
            for (int i = 0; i < columnNames.size(); ++i) {
                if (partType.getColumnElement(i) != cur) continue;
                filtered.add(columnNames.get(i));
                if (!it.hasNext()) break;
                cur = (PsiElement)it.next();
            }
            ArrayList arrayList = filtered;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "nameElements"));
            }
            return arrayList;
        }
        JBIterable jBIterable = elements.transform((Function)new Function<PsiElement, CharSequence>(){

            public CharSequence fun(PsiElement element) {
                return SqlShouldBeInGroupByInspection.getResolvedColumnName(dialect, ref, element);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection", "nameElements"));
        }
        return jBIterable;
    }

    private static class AddToGroupByQuickFix
    implements LocalQuickFix {
        private AddToGroupByQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlMessages.message("quickfix.name.add.to.group.by", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.inspections.group.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile file;
            SqlGroupByClause groupByClause;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix", "applyFix"));
            }
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), SqlReferenceExpression.class);
            SqlQueryExpression o = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlQueryExpression.class);
            SqlTableExpression tableExpression = o != null ? o.getTableExpression() : null;
            SqlGroupByClause sqlGroupByClause = groupByClause = tableExpression != null ? tableExpression.getGroupByClause() : null;
            if (groupByClause == null) {
                return;
            }
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            Document document = instance.getDocument(file = ref.getContainingFile());
            if (document == null) {
                return;
            }
            int end = groupByClause.getTextRange().getEndOffset();
            PsiElement last = groupByClause.getLastChild();
            boolean needComma = true;
            if (last == null) {
                needComma = false;
            } else {
                IElementType type = last.getNode().getElementType();
                if (type == TokenType.ERROR_ELEMENT || type == SqlCommonKeywords.SQL_GROUP || type == SqlCommonKeywords.SQL_BY) {
                    needComma = false;
                }
            }
            JBIterable elements = SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o);
            if (elements.isEmpty()) {
                return;
            }
            Iterable names = SqlShouldBeInGroupByInspection.nameElements(tableExpression, ref, (JBIterable<PsiElement>)elements);
            document.insertString(end, (CharSequence)((needComma ? "," : "") + " " + StringUtil.join((Iterable)names, (String)", ")));
        }
    }
}

