/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SqlQuoteIdentifierIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.name.quote.identifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "isAvailable"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null || editor == null || !(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier identifier = SqlIntentionUtil.getIdentifier(element);
        if (identifier == null) {
            return false;
        }
        return !identifier.isQuotedIdentifier();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlQuoteIdentifierIntention", "invoke"));
        }
        SqlIdentifier identifier = SqlIntentionUtil.getIdentifier(element);
        if (identifier == null) {
            return;
        }
        SqlImplUtil.quoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

