/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSplitStringLiteralIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.name.split.string.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "isAvailable"));
        }
        SqlStringTokenElement string = SqlSplitStringLiteralIntention.currentStringToken(editor, file);
        if (string == null) {
            return false;
        }
        return string.getRangeInElement().contains(editor.getCaretModel().getOffset() - string.getTextOffset());
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "invoke"));
        }
        final SqlStringTokenElement string = SqlSplitStringLiteralIntention.currentStringToken(editor, file);
        if (string != null) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    SqlSplitStringLiteralIntention.splitLiteral(string, project, editor, file);
                }
            }, null, (Object)editor.getDocument());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static SqlStringTokenElement currentStringToken(Editor editor, PsiFile file) {
        return (SqlStringTokenElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), SqlStringTokenElement.class, (boolean)false);
    }

    private static int getConcatExpr(@NotNull DdlBuilder builder, @NotNull String a, @NotNull String b) {
        int res;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "getConcatExpr"));
        }
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "getConcatExpr"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "getConcatExpr"));
        }
        DatabaseFamilyId id = builder.getDialect().getFamilyId();
        if (id.isMysql()) {
            builder.keyword("CONCAT").symbol("(").literal(a).symbol(",").space();
            res = builder.length();
            builder.symbol(",").space().literal(b).symbol(")");
        } else {
            String op = id.isTransactSql() ? "+" : "||";
            builder.literal(a).space().symbol(op).space();
            res = builder.length();
            builder.space().symbol(op).space().literal(b);
        }
        return res;
    }

    @Nullable
    private static IElementType getNodeType(@Nullable PsiElement e) {
        ASTNode node = e == null ? null : e.getNode();
        return node == null ? null : node.getElementType();
    }

    @NotNull
    private static TextRange findLiteralRange(@NotNull SqlStringTokenElement string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "findLiteralRange"));
        }
        if (SqlSplitStringLiteralIntention.getNodeType((PsiElement)string) == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Object prev = PsiTreeUtil.prevLeaf((PsiElement)string);
            Object next = PsiTreeUtil.nextLeaf((PsiElement)string);
            if (SqlSplitStringLiteralIntention.getNodeType(prev) != SqlTokens.SQL_CUSTOM_LQUOTE || prev == null) {
                prev = string;
            }
            if (SqlSplitStringLiteralIntention.getNodeType(next) != SqlTokens.SQL_CUSTOM_RQUOTE || next == null) {
                next = string;
            }
            TextRange textRange = TextRange.create((int)prev.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "findLiteralRange"));
            }
            return textRange;
        }
        TextRange textRange = string.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlSplitStringLiteralIntention", "findLiteralRange"));
        }
        return textRange;
    }

    private static void splitLiteral(final SqlStringTokenElement string, final Project project, final Editor editor, PsiFile file) {
        final TextRange outerRange = SqlSplitStringLiteralIntention.findLiteralRange(string);
        final TextRange innerRange = string.getRangeInElement().shiftRight(string.getTextRange().getStartOffset() - outerRange.getStartOffset());
        final int splitPosition = SqlSplitStringLiteralIntention.findSplitPosition(string, outerRange, editor);
        if (splitPosition != -1) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Split string literal", (String)"Split string literal", (Runnable)new Runnable(){

                @Override
                public void run() {
                    String text = editor.getDocument().getText(outerRange);
                    String bquote = text.substring(0, innerRange.getStartOffset());
                    String equote = text.substring(innerRange.getEndOffset(), outerRange.getLength());
                    DdlBuilder builder = new DdlBuilder(new StringBuilder(string.getTextLength() + 20)).configureBuilder(project).withDialect(SqlImplUtil.getSqlDialectSafe((PsiElement)string).getDatabaseDialect());
                    int cur = SqlSplitStringLiteralIntention.getConcatExpr(builder, text.substring(0, splitPosition) + equote, bquote + text.substring(splitPosition));
                    editor.getDocument().replaceString(outerRange.getStartOffset(), outerRange.getEndOffset(), (CharSequence)builder.getStatement());
                    editor.getCaretModel().moveToOffset(cur += outerRange.getStartOffset());
                }
            }, (PsiFile[])new PsiFile[]{file});
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
        }
    }

    private static int findSplitPosition(SqlStringTokenElement string, TextRange literalRange, Editor editor) {
        PsiElement parent = string.getParent();
        int caret = editor.getCaretModel().getOffset();
        if (parent instanceof SqlStringLiteralExpression) {
            return SqlSplitStringLiteralIntention.findSplitPosition((SqlStringLiteralExpression)parent, caret);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)editor.getProject());
        SqlStringLiteralExpression literal = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)facade.createExpressionFragment((Language)SqlImplUtil.getSqlDialectSafe((PsiElement)string), null, editor.getDocument().getText(literalRange)), SqlStringLiteralExpression.class);
        if (literal == null) {
            return -1;
        }
        return SqlSplitStringLiteralIntention.findSplitPosition(literal, caret - literalRange.getStartOffset());
    }

    private static int findSplitPosition(SqlStringLiteralExpression literal, int caret) {
        StringBuilder dummy;
        int innerCaretOffset;
        TextRange innerRange = SqlStringLiteralManipulator.getStringTokenRange((SqlStringLiteralExpressionImpl)literal);
        if (!innerRange.contains(innerCaretOffset = caret - literal.getTextRange().getStartOffset())) {
            return -1;
        }
        LiteralTextEscaper esc = literal.createLiteralTextEscaper();
        if (!esc.decode(innerRange, dummy = new StringBuilder(literal.getTextLength()))) {
            return -1;
        }
        int pos = SqlSplitStringLiteralIntention.findDecodedSplitPosition(esc, innerRange, innerCaretOffset, 0, dummy.length());
        return pos == -1 ? -1 : esc.getOffsetInHost(pos, innerRange);
    }

    private static int findDecodedSplitPosition(LiteralTextEscaper<?> esc, TextRange innerRange, int h, int s, int e) {
        if (esc.getOffsetInHost(s, innerRange) == h) {
            return s;
        }
        if (esc.getOffsetInHost(e, innerRange) == h) {
            return e;
        }
        do {
            int m;
            int pos;
            if ((pos = esc.getOffsetInHost(m = (s + e) / 2, innerRange)) < h) {
                s = m;
                continue;
            }
            if (pos > h) {
                e = m;
                continue;
            }
            return m;
        } while (s + 1 < e);
        return e;
    }
}

