/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.fragments.SqlCodeFragmentImpl;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.sql.script.SqlScriptModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPsiFacadeImpl
extends SqlPsiFacade {
    private final Project myProject;

    public SqlPsiFacadeImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public SqlLanguageDialect getDefaultDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(this.myProject, null);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "getDefaultDialect"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlScriptModel createScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createScriptModel"));
        }
        SqlScriptModel sqlScriptModel = new SqlScriptModel(file);
        if (sqlScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createScriptModel"));
        }
        return sqlScriptModel;
    }

    @NotNull
    public SqlReader createSqlReader() {
        SqlReaderImpl sqlReaderImpl = new SqlReaderImpl(this.myProject);
        if (sqlReaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createSqlReader"));
        }
        return sqlReaderImpl;
    }

    @NotNull
    public PsiCodeFragment createTableReferenceFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable DbElement schemaElement, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, "dummy.sql", text, true);
        codeFragment.setContext((PsiElement)schemaElement);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createTypeElementFragment(@NotNull Language dialect, @Nullable DbDataSource context, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @NotNull String text, @NotNull String contextQuery) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (contextQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextQuery", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlFile file = (SqlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.sql", dialect, (CharSequence)contextQuery);
        final Ref ref = Ref.create();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof SqlQueryExpression) {
                    ref.set((Object)((SqlQueryExpression)element));
                } else {
                    super.visitElement(element);
                }
            }
        });
        if (!ref.isNull()) {
            codeFragment.setContext((PsiElement)ref.get());
        }
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        return sqlCodeFragmentImpl;
    }
}

