/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDmlInstructionImpl
extends SqlCompositeElementImpl
implements SqlDmlInstruction {
    public SqlDmlInstructionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlDmlInstructionImpl", "<init>"));
        }
        super(node);
    }

    public SqlExpression getTargetExpression() {
        SqlTableColumnsList tableColumnsList = (SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class);
        return tableColumnsList != null ? tableColumnsList.getTableExpression() : (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    @NotNull
    public List<SqlReferenceExpression> getTargetColumnReferences() {
        List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList((SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDmlInstructionImpl", "getTargetColumnReferences"));
        }
        return list;
    }

    public SqlTableType getTargetType() {
        SqlExpression targetExpression = this.getTargetExpression();
        if (targetExpression == null) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList((SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class));
        SqlTableType baseType = SqlTableTypeBase.ensureTableType(targetExpression.getSqlType(), (SqlElement)targetExpression, this.getParent());
        if (referenceList.isEmpty()) {
            return baseType;
        }
        return baseType.alias(null, (PsiElement)this, referenceList);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlDmlInstruction((SqlDmlInstruction)this);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlQueryExpression query;
        SqlUsingClause[] usingClauses;
        SqlExpression targetRoot;
        SqlExpression targetExpression = this.getTargetExpression();
        Object object = targetRoot = targetExpression != null && targetExpression.getParent() instanceof SqlTableColumnsList ? (SqlTableColumnsList)targetExpression.getParent() : targetExpression;
        if (lastParent != targetRoot && targetExpression != null && !(lastParent instanceof SqlQueryExpression)) {
            if (targetExpression instanceof SqlReferenceExpression) {
                SqlReferenceExpression expression = (SqlReferenceExpression)targetExpression;
                for (SqlUsingClause sqlUsingClause : expression.multiResolve(false)) {
                    if (sqlUsingClause.getElement() == null || processor.execute(sqlUsingClause.getElement(), state)) continue;
                    return false;
                }
                if (!SqlImplUtil.processQualifier(expression, processor, state, place)) {
                    return false;
                }
            } else {
                if (targetExpression instanceof SqlDefinition && !processor.execute((PsiElement)targetExpression, state)) {
                    return false;
                }
                SqlType type = targetExpression.getSqlType();
                if (type instanceof SqlTableType && !SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state)) {
                    return false;
                }
            }
        }
        if ((usingClauses = (SqlUsingClause[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlUsingClause.class)) != null && !Arrays.asList(usingClauses).contains(lastParent)) {
            for (SqlUsingClause sqlUsingClause : usingClauses) {
                SqlType type;
                SqlExpression usingExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)sqlUsingClause, SqlExpression.class);
                SqlType sqlType = type = usingExpression == null ? null : usingExpression.getSqlType();
                if (!(type instanceof SqlTableType) || SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state)) continue;
                return false;
            }
        }
        if (lastParent != (query = (SqlQueryExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlQueryExpression.class)) && query != null && !query.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }
}

