/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.psi.DbPsiFacade;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinExpressionImpl
extends SqlBinaryExpressionImpl
implements SqlJoinExpression {
    private CachedValue<SqlTableType> myType;

    public SqlJoinExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlJoinExpression((SqlJoinExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getOpSignElement() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (!(type instanceof SqlKeywordTokenType) && type != SqlTokens.SQL_COMMA) continue;
            PsiElement psiElement = child.getPsi();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "getOpSignElement"));
            }
            return psiElement;
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public IElementType getOpSign() {
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_JOIN;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "getOpSign"));
        }
        return sqlTokenType;
    }

    @NotNull
    public SqlTableType getSqlType() {
        if (this.myType == null) {
            this.myType = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<SqlTableType>(){

                public CachedValueProvider.Result<SqlTableType> compute() {
                    return CachedValueProvider.Result.create((Object)SqlJoinExpressionImpl.this.calcType(), (Object[])new Object[]{SqlJoinExpressionImpl.this, DbPsiFacade.getInstance((Project)SqlJoinExpressionImpl.this.getProject())});
                }
            }, false);
        }
        SqlTableType sqlTableType = (SqlTableType)this.myType.getValue();
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    @NotNull
    private SqlTableType calcType() {
        PsiElement natural;
        SqlExpression lOperand = this.getLOperand();
        SqlType lType = lOperand.getSqlType();
        SqlTableType expressionType = lType instanceof SqlTableType ? (SqlTableType)lType : SqlTableTypeBase.EMPTY_TABLE;
        for (PsiElement child = lOperand.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof SqlExpression)) continue;
            SqlExpression operand = (SqlExpression)child;
            expressionType = expressionType.join(SqlTableTypeBase.ensureTableType(operand.getSqlType(), (SqlElement)operand, (PsiElement)this));
        }
        SqlUsingClause using = (SqlUsingClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlUsingClause.class);
        if (using != null) {
            SqlReferenceList refList = using.getReferenceList();
            List list = refList != null ? refList.getReferenceList() : ContainerUtil.emptyList();
            for (SqlReferenceExpression expression : list) {
                PsiElement resolve = expression.resolve();
                if (resolve == null) continue;
                int count = expressionType.getColumnCount();
                ArrayList<PsiElement> unionColumns = new ArrayList<PsiElement>();
                for (int i = 0; i < count; ++i) {
                    PsiElement element = expressionType.getColumnElement(i);
                    if (!resolve.isEquivalentTo(element)) continue;
                    unionColumns.add(element);
                }
                for (PsiElement element : unionColumns) {
                    expressionType = expressionType.subtract(element);
                }
            }
        }
        if ((natural = this.findChildByType((IElementType)SqlCommonKeywords.SQL_NATURAL)) != null) {
            int count = expressionType.getColumnCount();
            MultiMap map = MultiMap.create((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (int i = 0; i < count; ++i) {
                String name = expressionType.getColumnName(i);
                PsiElement element = expressionType.getColumnElement(i);
                map.putValue((Object)name, (Object)element);
            }
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.size() != 2) continue;
                expressionType = expressionType.subtract((PsiElement)ContainerUtil.getFirstItem((Collection)value));
            }
        }
        SqlTableType sqlTableType = expressionType;
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "calcType"));
        }
        return sqlTableType;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        SqlType type;
        SqlFunctionCallExpression call;
        boolean fromAlias;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlJoinExpressionImpl", "processDeclarations"));
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)place, (boolean)false)) {
            return true;
        }
        boolean bl = fromAlias = lastParent instanceof SqlExpression && lastParent.getParent() == this;
        if (!fromAlias && !SqlImplUtil.processDeclarationsInType(this.getSqlType(), processor, state)) {
            return false;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        boolean isPg = dialect.getFamilyId().isPostgres();
        return !fromAlias || !isPg || (call = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)place, SqlFunctionCallExpression.class)) == null || !StringUtil.equalsIgnoreCase((CharSequence)"unnest", (CharSequence)call.getFirstChild().getText()) || !PsiTreeUtil.isAncestor((PsiElement)this.getROperand(), (PsiElement)place, (boolean)false) || !((type = this.getLOperand().getSqlType()) instanceof SqlTableType) || SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state);
    }
}

