/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParenthesizedExpressionImpl
extends SqlExpressionImpl
implements SqlParenthesizedExpression {
    public SqlParenthesizedExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlParenthesizedExpression((SqlParenthesizedExpression)this);
    }

    @NotNull
    public List<SqlExpression> getExpressionList() {
        List list = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlExpression.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl", "getExpressionList"));
        }
        return list;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        boolean tableTypeExpected;
        List<SqlExpression> list = this.getExpressionList();
        boolean bl = tableTypeExpected = this.getParent() instanceof SqlValuesExpression || PsiUtilCore.getElementType((PsiElement)this.getFirstChild()) == SqlCommonKeywords.SQL_ROW;
        if (list.size() == 0) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : SqlType.UNKNOWN;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl", "getSqlType"));
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            SqlType sqlType = list.get(0).getSqlType();
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl", "getSqlType"));
            }
            return sqlType;
        }
        ValuesTableType valuesTableType = new ValuesTableType();
        if (valuesTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl", "getSqlType"));
        }
        return valuesTableType;
    }

    private class ValuesTableType
    extends SqlTableTypeBase {
        private ValuesTableType() {
        }

        public int getColumnCount() {
            return SqlParenthesizedExpressionImpl.this.getExpressionList().size();
        }

        public String getColumnName(int i) {
            return String.valueOf(i);
        }

        public SqlType getColumnType(int i) {
            return SqlParenthesizedExpressionImpl.this.getExpressionList().get(i).getSqlType();
        }

        public DataType getDataType(int i) {
            SqlExpression expr = SqlParenthesizedExpressionImpl.this.getExpressionList().get(i);
            SqlType exprType = expr.getSqlType();
            return ValuesTableType.ensureTableType(exprType, (SqlElement)expr, null).getDataType(0);
        }

        @Nullable
        public PsiElement getColumnQualifier(int i) {
            return SqlParenthesizedExpressionImpl.this;
        }

        @NotNull
        public PsiElement getColumnElement(int i) {
            PsiElement psiElement = (PsiElement)SqlParenthesizedExpressionImpl.this.getExpressionList().get(i);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParenthesizedExpressionImpl$ValuesTableType", "getColumnElement"));
            }
            return psiElement;
        }

        @Nullable
        public PsiElement getSourceColumnElement(int i) {
            return (PsiElement)SqlParenthesizedExpressionImpl.this.getExpressionList().get(i);
        }
    }
}

