/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenElement;
import org.jetbrains.annotations.NotNull;

public class SqlStringTokenElement
extends SqlTokenElement {
    public SqlStringTokenElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlStringTokenElement", "<init>"));
        }
        super(type, text);
    }

    @NotNull
    public String getTokenText() {
        String string = SqlStringTokenElement.getTokenText((ASTNode)this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
        }
        return string;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = SqlStringTokenElement.getRangeInElement((ASTNode)this);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getRangeInElement"));
        }
        return textRange;
    }

    @NotNull
    static String getTokenText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
        }
        String unescapedText = StringUtil.notNullize((String)(node instanceof PsiElement ? InjectedLanguageUtil.getUnescapedLeafText((PsiElement)((PsiElement)node), (boolean)false) : node.getText()));
        if (unescapedText.length() < 2 || node.getElementType() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            String string = unescapedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
            }
            return string;
        }
        int end = unescapedText.length() - 1;
        char quoteChar = unescapedText.charAt(end);
        String quote = String.valueOf(quoteChar);
        int idx = unescapedText.indexOf(quoteChar == ']' ? 91 : (int)quoteChar);
        if (idx < 0) {
            String string = unescapedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
            }
            return string;
        }
        int begin = idx + 1;
        if (begin > end) {
            String string = unescapedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
            }
            return string;
        }
        String unquoted = unescapedText.substring(begin, end);
        String string = quoteChar == ']' ? unquoted : StringUtil.replace((String)unquoted, (String)(quote + quote), (String)quote);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getTokenText"));
        }
        return string;
    }

    @NotNull
    static TextRange getRangeInElement(@NotNull ASTNode node) {
        TextRange result;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getRangeInElement"));
        }
        String text = node.getText();
        int length = text.length();
        IElementType type = node.getElementType();
        if (type == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            result = TextRange.from((int)0, (int)length);
        } else {
            int prefixLength;
            char start = type == SqlTokens.SQL_STRING_TOKEN ? Character.toUpperCase(text.charAt(0)) : (char)'\u0000';
            char prefix = start == 'N' || start == 'B' || start == 'X' ? start : (char)'\u0000';
            int n = prefixLength = prefix == '\u0000' ? 0 : 1;
            if (length - prefixLength == 1) {
                TextRange textRange = TextRange.from((int)0, (int)length);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getRangeInElement"));
                }
                return textRange;
            }
            if (prefix != '\u0000') {
                SqlStringTokenElement.assertCorrectLength(node, length - 3);
                result = TextRange.from((int)2, (int)(length - 3));
            } else {
                SqlStringTokenElement.assertCorrectLength(node, length - 2);
                result = TextRange.from((int)1, (int)(length - 2));
            }
        }
        TextRange textRange = result;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringTokenElement", "getRangeInElement"));
        }
        return textRange;
    }

    private static void assertCorrectLength(@NotNull ASTNode node, int length) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlStringTokenElement", "assertCorrectLength"));
        }
        if (length >= 0) {
            return;
        }
        PsiElement psi = node.getPsi();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)psi.getProject()).getInjectionHost(psi);
        PsiFile file = psi.getContainingFile();
        TextRange range = node.getTextRange();
        String fileText = file.getText();
        int d = 50;
        TextRange fragmentRange = TextRange.create((int)Math.max(0, range.getStartOffset() - d), (int)Math.min(fileText.length(), range.getEndOffset() + d));
        String fragment = fragmentRange.substring(fileText);
        SqlDialectImplUtil.LOG.error(String.format("length: %s; type: %s; range: %s; text: %s\nhost.lang: %s; text: %s;\nfile.lang: %s(%s); length: %s; class: %s; file.name: %s\nfile.fragment%s: %s", length, node.getElementType(), range, node.getText(), host == null ? "<null>" : host.getLanguage().getID(), host == null ? "<null>" : host.getText(), file.getLanguage().getID(), file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage().getID() : "<null>", fileText.length(), file.getClass().getSimpleName(), file.getName(), fragmentRange, fragment) + (host != null ? "\nhost.lang: " + host.getLanguage().getID() + "; host.text: " + host.getText() + ";" : ""));
    }
}

