/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.util.TokenPattern;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreprocessingLexer
extends DelegateLexer {
    private Integer myStoredState;
    private MatchState myMatchState;
    private int myEndOffset;

    public PreprocessingLexer(@NotNull Lexer delegate, TokenPattern pattern) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/sql/psi/impl/lexer/PreprocessingLexer", "<init>"));
        }
        super(delegate);
        this.myMatchState = new MatchState(pattern);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/psi/impl/lexer/PreprocessingLexer", "start"));
        }
        if (initialState < 0) {
            initialState = -initialState - 1;
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myMatchState.reset(buffer);
        this.myEndOffset = endOffset;
        this.myMatchState.findMatchOn(startOffset, this.myEndOffset);
        this.processAdvance();
    }

    private void matchReady(int state) {
        this.myStoredState = state;
        this.onNextMatched();
    }

    private void correctCurrentMatch() {
        assert (this.myMatchState.myMatchedStart >= super.getTokenStart());
        if (this.myMatchState.myMatchedStart >= super.getTokenEnd()) {
            return;
        }
        if (this.skipToken(super.getTokenType())) {
            this.myMatchState.findMatchOn(super.getTokenEnd(), this.myEndOffset);
        }
    }

    protected boolean skipToken(IElementType tokenType) {
        return false;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myStoredState != null) {
            if (!this.advanceInMatched()) {
                if (this.myMatchState.myMatchedEnd == super.getTokenEnd()) {
                    super.advance();
                    this.myMatchState.findMatchOn(this.myMatchState.myMatchedEnd, this.myEndOffset);
                    this.processAdvance();
                } else {
                    this.start(this.getBufferSequence(), this.myMatchState.myMatchedEnd, this.myEndOffset, this.myStoredState);
                }
            }
        } else if (this.myMatchState.myMatchedStart < this.myEndOffset && this.myMatchState.myMatchedStart < super.getTokenEnd()) {
            this.matchReady(this.getState());
        } else {
            super.advance();
            this.processAdvance();
        }
    }

    private void processAdvance() {
        this.correctCurrentMatch();
        if (this.myMatchState.myMatchedStart == super.getTokenStart()) {
            this.matchReady(this.getState());
        } else {
            this.myStoredState = null;
        }
    }

    public int getState() {
        return this.myStoredState != null ? -this.myStoredState.intValue() - 1 : super.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myStoredState != null ? this.getMatchedTokenType() : super.getTokenType();
    }

    public int getTokenStart() {
        return this.myStoredState != null ? this.getMatchedTokenStart() : super.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myStoredState != null ? this.getMatchedTokenEnd() : Math.min(super.getTokenEnd(), this.myMatchState.myMatchedStart);
    }

    protected void onNextMatched() {
    }

    protected MatchResult getMatch() {
        return this.myMatchState.myMatcher.getResult();
    }

    protected boolean advanceInMatched() {
        return false;
    }

    protected abstract IElementType getMatchedTokenType();

    protected int getMatchedTokenStart() {
        return this.myMatchState.myMatchedStart;
    }

    protected int getMatchedTokenEnd() {
        return this.myMatchState.myMatchedEnd;
    }

    private static class MatchState {
        private final TokenPattern.Matcher myMatcher;
        private int myMatchedStart = -1;
        private int myMatchedEnd = -1;

        public MatchState(TokenPattern pattern) {
            this.myMatcher = pattern.newMatcher();
        }

        public void reset(CharSequence buffer) {
            this.myMatcher.reset(buffer);
            this.myMatchedStart = -1;
            this.myMatchedEnd = -1;
        }

        public boolean findMatchOn(int offset, int limit) {
            if (offset <= limit) {
                boolean found = this.myMatcher.find(offset, limit);
                if (found && this.myMatcher.start() == this.myMatcher.end()) {
                    throw new AssertionError((Object)"Pattern matches empty text");
                }
                if (found) {
                    this.myMatchedStart = this.myMatcher.start();
                    this.myMatchedEnd = this.myMatcher.end();
                    return true;
                }
            }
            this.myMatchedStart = Integer.MAX_VALUE;
            this.myMatchedEnd = Integer.MIN_VALUE;
            return false;
        }
    }
}

