/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlGenericDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlGenericDefinitionStubElementType<T extends SqlDefinition>
extends SqlStubElementType<SqlGenericDefinitionStub<T>, T> {
    public static final NotNullFunction<String, SqlGenericDefinitionStubElementType> FACTORY = new NotNullFunction<String, SqlGenericDefinitionStubElementType>(){

        public SqlGenericDefinitionStubElementType fun(String name) {
            return new SqlGenericDefinitionStubElementType(name);
        }
    };

    public SqlGenericDefinitionStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "<init>"));
        }
        super(debugName);
    }

    public SqlGenericDefinitionStub<T> createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "createStub"));
        }
        SqlNameElement nameElement = psi.getNameElement();
        String typeName = nameElement == null ? null : ((SqlReferenceExpression)nameElement).getReferenceElementType().toString();
        return new SqlGenericDefinitionStub(parentStub, this, SqlGenericDefinitionStubElementType.asStringRef((PsiElement)nameElement), typeName == null ? null : StringRef.fromString((String)typeName));
    }

    public void serialize(@NotNull SqlGenericDefinitionStub<T> stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getReferenceTypeName());
    }

    @NotNull
    public SqlGenericDefinitionStub<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "deserialize"));
        }
        SqlGenericDefinitionStub sqlGenericDefinitionStub = new SqlGenericDefinitionStub(parentStub, this, dataStream.readName(), dataStream.readName());
        if (sqlGenericDefinitionStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "deserialize"));
        }
        return sqlGenericDefinitionStub;
    }

    @Override
    public void indexStub(@NotNull SqlGenericDefinitionStub<T> stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlGenericDefinitionStubElementType", "indexStub"));
        }
        SqlGenericDefinitionStubElementType.indexNamedStub(stub, SqlAllNameIndex.KEY, sink);
    }
}

