/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlTableStub
extends SqlNamedElementStub<SqlTableDefinition> {
    private final StringRef myExpressionText;
    private SqlExpression myExpression;

    protected SqlTableStub(StubElement parent, @NotNull SqlTableElementType elementType, StringRef name, StringRef expressionText) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlTableStub", "<init>"));
        }
        super(parent, elementType, name);
        this.myExpressionText = expressionText;
    }

    public String getExpressionText() {
        return this.myExpressionText == null ? null : this.myExpressionText.getString();
    }

    public SqlExpression getExpression() {
        String text;
        if (this.myExpression == null && StringUtil.isNotEmpty((String)(text = this.getExpressionText()))) {
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myExpression = SqlPsiElementFactory.createQueryExpressionFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myExpression;
    }
}

