/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlSemicolonFixer
extends SmartEnterProcessorWithFixers.Fixer {
    public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor, @NotNull PsiElement element) {
        String insDelim;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/smartenter/SqlSemicolonFixer", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/smartenter/SqlSemicolonFixer", "apply"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/smartenter/SqlSemicolonFixer", "apply"));
        }
        if (!(element instanceof SqlStatement)) {
            return;
        }
        SqlStatement statement = (SqlStatement)element;
        String delim = DbSqlUtil.getDelimiterAt(element.getContainingFile(), element.getTextOffset());
        String string = insDelim = !DbSqlUtil.delimiterNeedsSpacing(delim) ? delim : " " + delim;
        if (PsiTreeUtil.hasErrorElements((PsiElement)statement)) {
            int offset;
            int textLength = editor.getDocument().getTextLength();
            int lineEnd = editor.getCaretModel().getVisualLineEnd();
            int n = offset = lineEnd > 0 ? lineEnd - 1 : lineEnd;
            if (offset == 0 || !editor.getDocument().getText(TextRange.from((int)(offset - delim.length()), (int)delim.length())).equals(delim)) {
                editor.getDocument().insertString(lineEnd == textLength ? lineEnd : offset, (CharSequence)insDelim);
            }
        } else {
            PsiElement nonWsSiblingPsi = PsiTreeUtil.nextVisibleLeaf((PsiElement)statement);
            ASTNode nonWhitespaceSibling = nonWsSiblingPsi == null ? null : nonWsSiblingPsi.getNode();
            PsiElement lastChild = statement.getLastChild();
            TokenSet seps = SqlImplUtil.getSqlDialectSafe(element).getStatementSeparators();
            if (lastChild != null && seps.contains(lastChild.getNode().getElementType())) {
                return;
            }
            if (nonWhitespaceSibling == null || !seps.contains(nonWhitespaceSibling.getElementType())) {
                editor.getDocument().insertString(statement.getTextRange().getEndOffset(), (CharSequence)insDelim);
            }
        }
        processor.commit(editor);
    }
}

