/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.util.NullableFunction;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JamClassAttributeMeta<JamType>
extends JamAttributeMeta<JamType> {
    public JamClassAttributeMeta(String attrName) {
        super(attrName);
    }

    public static class Single
    extends JamClassAttributeMeta<JamClassAttributeElement> {
        public Single(String attrName) {
            super(attrName);
        }

        @Override
        @NotNull
        public JamClassAttributeElement getJam(PsiElementRef<PsiAnnotation> anno) {
            JamClassAttributeElement jamClassAttributeElement = new JamClassAttributeElement(anno, this.getAttributeLink().getAttributeName());
            if (jamClassAttributeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamClassAttributeMeta$Single", "getJam"));
            }
            return jamClassAttributeElement;
        }

        @NotNull
        public JamClassAttributeElement getJam(PsiElementRef<PsiAnnotation> anno, final Factory<PsiClass> defaultValue) {
            JamClassAttributeElement jamClassAttributeElement = new JamClassAttributeElement(anno, this.getAttributeLink().getAttributeName()){

                @Override
                public PsiClass getValue() {
                    PsiClass psiClass = super.getValue();
                    return psiClass == null ? (PsiClass)defaultValue.create() : psiClass;
                }
            };
            if (jamClassAttributeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamClassAttributeMeta$Single", "getJam"));
            }
            return jamClassAttributeElement;
        }
    }

    public static class Collection
    extends JamClassAttributeMeta<List<JamClassAttributeElement>> {
        public Collection(String attrName) {
            super(attrName);
        }

        @Override
        @NotNull
        public List<JamClassAttributeElement> getJam(PsiElementRef<PsiAnnotation> anno) {
            List<JamClassAttributeElement> list = this.getCollectionJam(anno, new NullableFunction<PsiAnnotationMemberValue, JamClassAttributeElement>(){

                public JamClassAttributeElement fun(PsiAnnotationMemberValue psiAnnotationMemberValue) {
                    return new JamClassAttributeElement(psiAnnotationMemberValue);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamClassAttributeMeta$Collection", "getJam"));
            }
            return list;
        }
    }
}

