/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class JamAbstractTreeBuilder
extends AbstractTreeBuilder {
    public JamAbstractTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, SimpleNode rootDescriptor) {
        this(tree, treeModel, new JamTreeStructure(rootDescriptor, project));
    }

    public JamAbstractTreeBuilder(JTree tree, SimpleTreeStructure structure) {
        this(tree, new DefaultTreeModel(new DefaultMutableTreeNode()), structure);
    }

    public JamAbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, SimpleTreeStructure structure) {
        super(tree, treeModel, structure, null);
        this.setNodeDescriptorComparator(AlphaComparator.INSTANCE);
    }

    @Override
    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAlwaysShowPlus();
    }

    @Override
    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return super.isAutoExpandNode(nodeDescriptor) || ((SimpleNode)nodeDescriptor).isAutoExpandNode();
    }

    @Override
    protected final void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/jam/view/tree/JamAbstractTreeBuilder", "expandNodeChildren"));
        }
        Object element = ((NodeDescriptor)node.getUserObject()).getElement();
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
        super.expandNodeChildren(node);
    }

    public void init() {
        this.initRootNode();
    }

    @Override
    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor;
    }

    @Override
    protected ProgressIndicator createProgressIndicator() {
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure != null && structure.isToBuildChildrenInBackground(this.getRootElement())) {
            return ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)new ProgressIndicatorBase(true), (Disposable)this);
        }
        return super.createProgressIndicator();
    }
}

