/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;

public class SelectionDependenciesPresentationModel<N, E>
extends BasicGraphPresentationModel<N, E> {
    private boolean myFilterDependenciesMode = true;

    public SelectionDependenciesPresentationModel(Graph graph) {
        super(graph);
    }

    public SelectionDependenciesPresentationModel(Graph graph, boolean filterDependencies) {
        super(graph);
        this.myFilterDependenciesMode = filterDependencies;
    }

    @Override
    public void setGraphBuilder(GraphBuilder<N, E> builder) {
        super.setGraphBuilder(builder);
        this.addGraph2DSelectionListener(builder);
    }

    protected void addGraph2DSelectionListener(GraphBuilder<N, E> builder) {
        builder.getGraph().addGraph2DSelectionListener(new MyGraph2DSelectionListener(builder));
    }

    public boolean isFilterDependenciesMode() {
        return this.myFilterDependenciesMode;
    }

    public void setFilterDependenciesMode(boolean filterDependenciesMode) {
        this.myFilterDependenciesMode = filterDependenciesMode;
        this.getGraphBuilder().updateGraph();
    }

    private class MyGraph2DSelectionListener
    implements Graph2DSelectionListener {
        private final GraphBuilder<N, E> myBuilder;

        public MyGraph2DSelectionListener(GraphBuilder<N, E> builder) {
            this.myBuilder = builder;
            builder.addCustomUpdater(new CustomGraphUpdater(){

                @Override
                public void update(Graph2D graph, Graph2DView view) {
                    if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode()) {
                        MyGraph2DSelectionListener.this.updateDependencies(false);
                    }
                }
            });
        }

        protected void updateDependencies(final boolean updateGraph) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphUtil.filterSelectedNodesDependencies(MyGraph2DSelectionListener.this.myBuilder, updateGraph);
                }
            });
        }

        @Override
        public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
            if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode() && e.isNodeSelection()) {
                this.updateDependencies(true);
            }
        }
    }
}

