/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ScriptingIndexableSetContributor
extends IndexableSetContributor {
    @Override
    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingIndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        Set<VirtualFile> set = this.getLibraryFiles(project);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingIndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingIndexableSetContributor", "getLibraryFiles"));
        }
        THashSet libFiles = new THashSet();
        LibraryKind libraryKind = this.getLibraryKind();
        libFiles.addAll(ScriptingLibraryManager.getAllLibraryFiles(project, libraryKind));
        libFiles.addAll(this.getPredefinedLibraryFiles(project));
        THashSet tHashSet = libFiles;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingIndexableSetContributor", "getLibraryFiles"));
        }
        return tHashSet;
    }

    protected abstract Set<VirtualFile> getPredefinedLibraryFiles(@NotNull Project var1);

    @Override
    @NotNull
    public final Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> set = this.getPredefinedFilesToIndex();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingIndexableSetContributor", "getAdditionalRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public abstract Set<VirtualFile> getPredefinedFilesToIndex();

    public abstract LibraryKind getLibraryKind();
}

