/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.ProjectTopics;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.MappingsChangeListener;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryMappings
extends LanguagePerFileMappings<ScriptingLibraryModel>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.webcore.libraries.ScriptingLibraryMappings");
    private final Map<VirtualFile, CompoundLibrary> myCompoundLibMap;
    private CompoundLibrary myProjectLibs;
    private final Map<String, List<VirtualFile>> myMappingsByLibraryNameCache;
    private final List<MappingsChangeListener> myMappingsChangeListeners;

    public ScriptingLibraryMappings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "<init>"));
        }
        super(project);
        this.myCompoundLibMap = ContainerUtil.newHashMap();
        this.myProjectLibs = new CompoundLibrary();
        this.myMappingsByLibraryNameCache = ContainerUtil.newConcurrentMap();
        this.myMappingsChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.registerLibraryTableListener(new MyLibraryTableListener(), this);
        MessageBusConnection conn = project.getMessageBus().connect((Disposable)project);
        conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            @Override
            public void rootsChanged(ModuleRootEvent event) {
                ScriptingLibraryMappings.this.myMappingsByLibraryNameCache.clear();
            }
        });
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @NotNull
    protected abstract ScriptingLibraryManager getLibraryManager();

    public void registerLibraryTableListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        LibraryTable libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        libTable.addListener(listener, parentDisposable);
        libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        libTable.addListener(listener, parentDisposable);
    }

    @Override
    protected String serialize(ScriptingLibraryModel library) {
        if (library instanceof CompoundLibrary) {
            return ((CompoundLibrary)library).serialize();
        }
        return this.getLibrarySerializationName(library);
    }

    @NotNull
    private String getLibrarySerializationName(@NotNull ScriptingLibraryModel library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
        }
        if (library.isPredefined()) {
            String string = this.getPredefinedLibrarySerializationName(library.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializationName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        String string = serializationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        String string = presentationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        return string;
    }

    public void reset() {
        this.getLibraryManager().reset();
        for (CompoundLibrary container : this.myCompoundLibMap.values()) {
            container.reset();
        }
        this.myProjectLibs.reset();
        this.myMappingsByLibraryNameCache.clear();
    }

    public void updateMappings() {
        Map map = this.getMappings();
        this.myCompoundLibMap.clear();
        this.myMappingsByLibraryNameCache.clear();
        this.myProjectLibs = new CompoundLibrary();
        for (VirtualFile file : map.keySet().toArray(new VirtualFile[map.size()])) {
            ScriptingLibraryModel value = (ScriptingLibraryModel)this.getImmediateMapping(file);
            if (!(value instanceof CompoundLibrary)) continue;
            CompoundLibrary container = (CompoundLibrary)value;
            ScriptingLibraryModel[] libModels = ScriptingLibraryModel.toArray(container.getLibraries());
            CompoundLibrary newContainer = new CompoundLibrary();
            for (ScriptingLibraryModel libraryModel : libModels) {
                String libName = libraryModel.getName();
                ScriptingLibraryModel updatedModel = this.getLibraryManager().getLibraryByName(libName);
                if (updatedModel == null) continue;
                newContainer.addLibrary(updatedModel);
            }
            this.setMapping(file, newContainer.isEmpty() ? null : newContainer);
            if (newContainer.isEmpty()) continue;
            if (file == null) {
                this.myProjectLibs = newContainer;
                continue;
            }
            this.myCompoundLibMap.put(file, newContainer);
        }
    }

    public void associate(@Nullable VirtualFile file, String libName, boolean isPredefined) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null || !(container instanceof CompoundLibrary)) {
            container = new CompoundLibrary();
        }
        ((CompoundLibrary)container).addLibrary(libraryModel);
        this.setMapping(file, container);
        if (libraryModel.isPredefined() != isPredefined) {
            LOG.error("Library " + libName + " is incorrectly treated as " + (isPredefined ? "predefined" : "normal") + " while it is created as " + (libraryModel.isPredefined() ? "predefined" : "normal"));
        }
        this.myMappingsByLibraryNameCache.remove(libName);
        this.fireOnAssociated(file, libName, isPredefined);
    }

    public void associateWithProject(String libName) {
        this.associate(null, libName);
    }

    public void disassociateWithProject(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "disassociateWithProject"));
        }
        this.disassociate(null, libraryName);
    }

    public void associate(@Nullable VirtualFile file, String libName) {
        this.associate(file, libName, false);
    }

    public void disassociate(@Nullable VirtualFile file, String libName) {
        this.myMappingsByLibraryNameCache.remove(libName);
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null) {
            return;
        }
        if (container instanceof CompoundLibrary && ((CompoundLibrary)container).containsLibrary(libName)) {
            ((CompoundLibrary)container).toggleLibrary(libraryModel);
            ((CompoundLibrary)container).applyChanges();
        }
        this.fireOnDisassociated(file, libName);
    }

    public boolean isAssociatedWithProject(String libName) {
        return this.isAssociatedWith(null, libName);
    }

    public boolean isAssociatedWith(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        return this.containsLibraryName(container, libName);
    }

    public boolean isLibraryInScopeFor(@Nullable VirtualFile file, @NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isLibraryInScopeFor"));
        }
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libraryName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(null);
        if (this.containsLibraryName(container, libraryName)) {
            return true;
        }
        if (file != null) {
            for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
                container = (ScriptingLibraryModel)this.getImmediateMapping(cur);
                if (!this.containsLibraryName(container, libraryName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsLibraryName(@Nullable ScriptingLibraryModel container, @NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "containsLibraryName"));
        }
        if (container == null) {
            return false;
        }
        if (container instanceof CompoundLibrary) {
            return ((CompoundLibrary)container).containsLibrary(libraryName);
        }
        return container.getName().equals(libraryName);
    }

    @Override
    @NotNull
    protected String getValueAttribute() {
        if ("libraries" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getValueAttribute"));
        }
        return "libraries";
    }

    @Override
    protected ScriptingLibraryModel handleUnknownMapping(VirtualFile file, String value) {
        if (value == null || !value.contains("{")) {
            return null;
        }
        String[] libNames = value.replace('{', ' ').replace('}', ' ').split(",");
        CompoundLibrary compoundLib = new CompoundLibrary();
        for (String libName : libNames) {
            String presentationName = this.getPredefinedLibraryPresentationName(libName.trim());
            ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(presentationName);
            if (libraryModel == null) continue;
            compoundLib.addLibrary(libraryModel);
        }
        if (file == null) {
            this.myProjectLibs = compoundLib;
        } else {
            this.myCompoundLibMap.put(file, compoundLib);
        }
        return compoundLib;
    }

    @Override
    public Collection<ScriptingLibraryModel> getAvailableValues(VirtualFile file) {
        List<ScriptingLibraryModel> libraries = this.getSingleLibraries();
        if (this.myCompoundLibMap.containsKey(file)) {
            libraries.add(this.myCompoundLibMap.get(file));
            return libraries;
        }
        CompoundLibrary compoundLib = new CompoundLibrary();
        this.myCompoundLibMap.put(file, compoundLib);
        libraries.add(compoundLib);
        return libraries;
    }

    @Override
    @Nullable
    public ScriptingLibraryModel chosenToStored(VirtualFile file, ScriptingLibraryModel value) {
        CompoundLibrary compoundLib;
        if (value instanceof CompoundLibrary) {
            return value;
        }
        CompoundLibrary compoundLibrary = compoundLib = file == null ? this.myProjectLibs : this.myCompoundLibMap.get(file);
        if (value == null) {
            if (compoundLib != null) {
                compoundLib.clearLibraries();
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        } else {
            if (compoundLib == null) {
                compoundLib = new CompoundLibrary();
                this.myCompoundLibMap.put(file, compoundLib);
            }
            compoundLib.toggleLibrary(value);
            if (compoundLib.isEmpty()) {
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        }
        return compoundLib;
    }

    @Override
    public boolean isSelectable(ScriptingLibraryModel value) {
        return !(value instanceof CompoundLibrary);
    }

    @Override
    protected List<ScriptingLibraryModel> getAvailableValues() {
        return this.getSingleLibraries();
    }

    @Override
    public ScriptingLibraryModel getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    public List<ScriptingLibraryModel> getSingleLibraries() {
        ArrayList<ScriptingLibraryModel> libraryModels = new ArrayList<ScriptingLibraryModel>();
        libraryModels.addAll(Arrays.asList(this.getLibraryManager().getAllLibraries()));
        return libraryModels;
    }

    public void dispose() {
    }

    public boolean isApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (!this.getLibraryManager().isLibraryFile(libFile)) {
            return true;
        }
        return this.isRecursivelyApplicable(libFile, srcFile);
    }

    private boolean isRecursivelyApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (srcFile == null) {
            return false;
        }
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getMapping(srcFile);
        if (libraryModel != null && libraryModel.containsFile(libFile)) {
            return true;
        }
        return this.isApplicable(libFile, srcFile.getParent());
    }

    private void iterateUp(@Nullable VirtualFile file, @NotNull Consumer<VirtualFile> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "iterateUp"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance(this.getProject()).getFileIndex();
        while (file != null && index.getModuleForFile(file) != null) {
            c.consume((Object)file);
            file = file.getParent();
        }
        c.consume(null);
    }

    public Set<VirtualFile> getLibraryFilesFor(VirtualFile file) {
        final HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        this.iterateUp(file, new Consumer<VirtualFile>(){

            public void consume(VirtualFile virtualFile) {
                ScriptingLibraryModel mapping = (ScriptingLibraryModel)ScriptingLibraryMappings.this.getMapping(virtualFile);
                if (mapping != null) {
                    mapping.addSignificantFiles(result);
                }
            }
        });
        return result;
    }

    public Set<ScriptingLibraryModel> getAllLibrariesInScope(VirtualFile file) {
        final HashSet<ScriptingLibraryModel> result = new HashSet<ScriptingLibraryModel>();
        this.iterateUp(file, new Consumer<VirtualFile>(){

            public void consume(VirtualFile virtualFile) {
                ScriptingLibraryModel mapping = (ScriptingLibraryModel)ScriptingLibraryMappings.this.getMapping(virtualFile);
                if (mapping instanceof CompoundLibrary) {
                    result.addAll(((CompoundLibrary)mapping).getLibraries());
                } else if (mapping != null) {
                    result.add(mapping);
                }
            }
        });
        return result;
    }

    @Override
    protected boolean shouldReparseFiles() {
        return false;
    }

    public boolean containsProjectLibrary(String name) {
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getImmediateMapping(null);
        if (libraryModel == null) {
            return false;
        }
        if (libraryModel instanceof CompoundLibrary) {
            return ((CompoundLibrary)libraryModel).containsLibrary(name);
        }
        return libraryModel.getName().equals(name);
    }

    public boolean containsLibrary(ScriptingLibraryModel libModel) {
        String libName = libModel.getName();
        for (ScriptingLibraryModel container : this.getMappings().values()) {
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOn(@NotNull Module module, @NotNull ScriptingLibraryModel libModel, int moduleCount) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "dependsOn"));
        }
        if (libModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libModel", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "dependsOn"));
        }
        String libName = libModel.getName();
        if (this.containsProjectLibrary(libName)) {
            return moduleCount == 1 || libModel.isAssociatedWith(module);
        }
        for (VirtualFile file : this.getMappings().keySet()) {
            ScriptingLibraryModel container = (ScriptingLibraryModel)this.getMapping(file);
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName) || !ModuleHelper.isSuitableModule(libModel, module, moduleCount, file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> getMappingsByLibraryName(final @NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryName"));
        }
        List<VirtualFile> mappings = this.myMappingsByLibraryNameCache.get(libraryName);
        if (mappings != null) {
            List<VirtualFile> list = mappings;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryName"));
            }
            return list;
        }
        mappings = ApplicationManager.getApplication().runReadAction(new Computable<List<VirtualFile>>(){

            public List<VirtualFile> compute() {
                Map allMappings = ScriptingLibraryMappings.this.getMappings();
                ArrayList roots = ContainerUtil.newArrayListWithCapacity((int)1);
                for (Map.Entry entry : allMappings.entrySet()) {
                    Collection<ScriptingLibraryModel> libraryModels;
                    ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)entry.getValue();
                    if (libraryModel instanceof CompoundLibrary) {
                        CompoundLibrary compoundLibrary = (CompoundLibrary)libraryModel;
                        libraryModels = compoundLibrary.getLibraries();
                    } else {
                        libraryModels = Collections.singletonList(libraryModel);
                    }
                    for (ScriptingLibraryModel model : libraryModels) {
                        String name = model != null ? model.getName() : null;
                        if (!libraryName.equals(name)) continue;
                        roots.add(entry.getKey());
                    }
                }
                return roots;
            }
        });
        this.myMappingsByLibraryNameCache.put(libraryName, mappings);
        List<VirtualFile> list = mappings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryName"));
        }
        return list;
    }

    public boolean isLibraryApplicableForFile(@NotNull String libraryName, @NotNull VirtualFile fileInProjectScope) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isLibraryApplicableForFile"));
        }
        if (fileInProjectScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileInProjectScope", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isLibraryApplicableForFile"));
        }
        List<VirtualFile> mappings = this.getMappingsByLibraryName(libraryName);
        return ScriptingLibraryMappings.isFileInScope(mappings, fileInProjectScope);
    }

    private static boolean isFileInScope(@NotNull List<VirtualFile> scopeRoots, @NotNull VirtualFile fileInProjectScope) {
        if (scopeRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeRoots", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isFileInScope"));
        }
        if (fileInProjectScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileInProjectScope", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isFileInScope"));
        }
        String filePath2 = fileInProjectScope.getPath();
        for (VirtualFile root : scopeRoots) {
            if (root == null) {
                return true;
            }
            if (!filePath2.startsWith(root.getPath())) continue;
            return true;
        }
        return false;
    }

    public void addMappingsChangeListener(@NotNull MappingsChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "addMappingsChangeListener"));
        }
        this.myMappingsChangeListeners.add(listener);
    }

    public void removeMappingsChangeListener(@NotNull MappingsChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "removeMappingsChangeListener"));
        }
        this.myMappingsChangeListeners.remove(listener);
    }

    private void fireOnAssociated(@Nullable VirtualFile file, @NotNull String libName, boolean isPredefined) {
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "fireOnAssociated"));
        }
        for (MappingsChangeListener listener : this.myMappingsChangeListeners) {
            listener.onAssociated(file, libName, isPredefined);
        }
    }

    private void fireOnDisassociated(@Nullable VirtualFile file, @NotNull String libName) {
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "fireOnDisassociated"));
        }
        for (MappingsChangeListener listener : this.myMappingsChangeListeners) {
            listener.onDisassociated(file, libName);
        }
    }

    private class MyLibraryTableListener
    implements LibraryTable.Listener {
        private MyLibraryTableListener() {
        }

        @Override
        public void afterLibraryAdded(Library newLibrary) {
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void afterLibraryRenamed(Library library) {
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void beforeLibraryRemoved(Library library) {
        }

        @Override
        public void afterLibraryRemoved(Library library) {
            ScriptingLibraryMappings.this.updateMappings();
        }
    }

    public class CompoundLibrary
    extends ScriptingLibraryModel {
        private final Map<String, ScriptingLibraryModel> myLibraries;
        private final Map<String, ScriptingLibraryModel> myOldLibraries;

        public CompoundLibrary() {
            super(null, null);
            this.myLibraries = new TreeMap<String, ScriptingLibraryModel>();
            this.myOldLibraries = new TreeMap<String, ScriptingLibraryModel>();
        }

        public void clearLibraries() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
            this.myLibraries.clear();
        }

        public void toggleLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "toggleLibrary"));
            }
            String libName = library.getName();
            if (this.myLibraries.containsKey(libName)) {
                this.myLibraries.remove(libName);
                return;
            }
            this.myLibraries.put(libName, library);
        }

        private void addLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "addLibrary"));
            }
            String libName = library.getName();
            this.myLibraries.put(libName, library);
            this.applyChanges();
        }

        public boolean containsLibrary(String libName) {
            return this.myLibraries.containsKey(libName);
        }

        @Nullable
        public String serialize() {
            ScriptingLibraryModel projectLibs = (ScriptingLibraryModel)ScriptingLibraryMappings.this.getImmediateMapping(null);
            boolean isProjectLevel = this == projectLibs;
            StringBuilder names = new StringBuilder();
            boolean isFirst = true;
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (isProjectLevel && library.isPredefined()) continue;
                names.append(isFirst ? "" : ", ");
                names.append(ScriptingLibraryMappings.this.getLibrarySerializationName(library));
                isFirst = false;
            }
            if (names.toString().isEmpty()) {
                return null;
            }
            return "{" + names.toString() + "}";
        }

        @Override
        public String getName() {
            StringBuilder allNames = new StringBuilder();
            boolean isFirst = true;
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                allNames.append(isFirst ? "" : ", ");
                allNames.append(library.getName());
                isFirst = false;
            }
            return allNames.toString();
        }

        @Override
        public boolean containsFile(VirtualFile file) {
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (!library.containsFile(file)) continue;
                return true;
            }
            return false;
        }

        public Collection<ScriptingLibraryModel> getLibraries() {
            return this.myLibraries.values();
        }

        @Override
        public boolean isEmpty() {
            return this.myLibraries.isEmpty();
        }

        public int getLibraryCount() {
            return this.myLibraries.size();
        }

        public void applyChanges() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
        }

        public boolean isModified() {
            if (this.myOldLibraries == null) {
                return false;
            }
            for (String libName : this.myLibraries.keySet()) {
                if (this.myOldLibraries.containsKey(libName)) continue;
                return true;
            }
            for (String libName : ArrayUtil.toStringArray(this.myOldLibraries.keySet())) {
                if (this.myLibraries.containsKey(libName)) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.myLibraries.clear();
            this.myLibraries.putAll(this.myOldLibraries);
        }

        @Override
        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            HashSet<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                sourceFiles.addAll(libModel.getSourceFiles());
            }
            HashSet<VirtualFile> hashSet = sourceFiles;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "getSourceFiles"));
            }
            return hashSet;
        }

        @Override
        public Set<VirtualFile> getCompactFiles() {
            HashSet<VirtualFile> compactFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                compactFiles.addAll(libModel.getCompactFiles());
            }
            return compactFiles;
        }

        @Override
        public void addSignificantFiles(Collection<VirtualFile> result) {
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.addSignificantFiles(result);
            }
        }
    }
}

