/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.inspections.StringCollectionExpression;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DefineVelocityPropertiesRefIntention
extends DefineInCommentIntention {
    public DefineVelocityPropertiesRefIntention(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention", "<init>"));
        }
        super(text, VelocityBundle.message("add.velocity.properties.ref.fix.name", new Object[0]));
    }

    @Override
    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention", "isAvailable"));
        }
        return ref.getParent() instanceof VtlMacroCall;
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, final @NotNull PsiElement element, String relativePath, final @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention", "prepareTemplate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention", "prepareTemplate"));
        }
        if (fileToInsertComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToInsertComment", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention", "prepareTemplate"));
        }
        List<String> allFiles = Util.collectFilePaths(element, new Function<PsiFile, String>(){

            public String fun(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$1", "fun"));
                }
                PsiFile file = psiFile.getViewProvider().getPsi((Language)PropertiesLanguage.INSTANCE);
                if (!(file instanceof PropertiesFile)) {
                    return null;
                }
                VelocityPropertiesProvider propertiesProvider = new VelocityPropertiesProvider((PropertiesFile)file);
                List macroLibs = DefineVelocityPropertiesRefIntention.collectReferencedLibFiles(ModuleUtil.findModuleForPsiElement((PsiElement)element), propertiesProvider);
                for (PsiFile macroLib : macroLibs) {
                    VirtualFile vFile;
                    String res;
                    if (!(macroLib instanceof VtlFile) || ((VtlFile)macroLib).getNumberOfMacros(((VtlReferenceExpression)element).getReferenceName()) <= 0 || (res = Util.computeFilePath(propertiesProvider, (vFile = macroLib.getViewProvider().getVirtualFile()).getPath(), vFile.getName(), fileToInsertComment)) == null) continue;
                    return res;
                }
                return null;
            }
        });
        template.addTextSegment("#* @velocityproperties path=");
        StringCollectionExpression pathExpression = new StringCollectionExpression(allFiles);
        template.addVariable("PATH", (Expression)pathExpression, (Expression)pathExpression, true);
        String fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment(fileRef + " *#\n");
        template.addEndVariable();
    }

    private static List<PsiFile> collectReferencedLibFiles(Module module, VelocityPropertiesProvider propertiesProvider) {
        String[] libNames = propertiesProvider.getVelocimacroLibraryNames();
        if (libNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PsiFile> files = new ArrayList<PsiFile>(libNames.length);
        for (String libName : libNames) {
            ContainerUtil.addAll(files, (Object[])Util.findReferencedFiles(module, libName));
        }
        return files;
    }

    public static class ModuleWide
    extends DefineVelocityPropertiesRefIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor, false);
        }
    }

    public static class LocalExternal
    extends DefineVelocityPropertiesRefIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.external", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor, true);
        }
    }

    public static class Local
    extends DefineVelocityPropertiesRefIntention {
        public Local() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$Local", "invoke"));
            }
            this.defineInComment(editor, file, file, false);
        }
    }
}

