/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.SoftFileReferenceSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFileReferenceSet
extends SoftFileReferenceSet {
    public VtlFileReferenceSet(@NotNull String text, @NotNull PsiElement element, int startInElement) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "<init>"));
        }
        super(text, element, startInElement);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        VtlFile file = this.getContainingVtlFile();
        if (file == null) {
            Collection collection = super.getDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "getDefaultContexts"));
            }
            return collection;
        }
        VelocityPropertiesProvider velocityProperties = file.getVelocityProperties();
        if (velocityProperties == null) {
            Collection collection = super.getDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "getDefaultContexts"));
            }
            return collection;
        }
        Collection<PsiFileSystemItem> collection = this.getVtlDefaultContexts(velocityProperties);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "getDefaultContexts"));
        }
        return collection;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getVtlDefaultContexts(@NotNull VelocityPropertiesProvider velocityProperties) {
        if (velocityProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "velocityProperties", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "getVtlDefaultContexts"));
        }
        PsiManager manager = this.getElement().getManager();
        ArrayList<PsiFileSystemItem> vtlDefaultContexts = new ArrayList<PsiFileSystemItem>();
        for (PsiFileSystemItem defaultContext : super.getDefaultContexts()) {
            for (VirtualFile resourceLoaderPath : velocityProperties.getResourceLoaderPathListBasedOn(defaultContext.getVirtualFile())) {
                PsiDirectory resourceLoaderContext = manager.findDirectory(resourceLoaderPath);
                ContainerUtil.addIfNotNull((Object)resourceLoaderContext, vtlDefaultContexts);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = vtlDefaultContexts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlFileReferenceSet", "getVtlDefaultContexts"));
        }
        return arrayList;
    }

    @Nullable
    private VtlFile getContainingVtlFile() {
        PsiFile psiFile = this.getElement().getContainingFile();
        return psiFile instanceof VtlFile ? (VtlFile)psiFile : null;
    }
}

