/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.args;

import com.vladium.util.IConstants;
import com.vladium.util.ResourceLoader;
import com.vladium.util.args.IOptsParser;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OptsParser
implements IOptsParser {
    private final String m_msgPrefix;
    private final OptDefMetadata m_metadata;
    private static final int CANONICAL_OPT_PREFIX = 1;
    private static final String[] OPT_PREFIXES = new String[]{"--", "-"};
    private static final char[] OPT_VALUE_SEPARATORS = new char[]{':', '='};
    private static final int STATE_OPT = 0;
    private static final int STATE_OPT_VALUE = 1;
    private static final int STATE_FREE_ARGS = 2;
    private static final int STATE_ERROR = 3;

    public synchronized void usage(PrintWriter out, int level, int width) {
        OptDef usageOptDef;
        String prefix = OPT_PREFIXES[1];
        Iterator i = this.m_metadata.getOptDefs();
        while (i.hasNext()) {
            int p;
            int padding;
            OptDef optdef = (OptDef)i.next();
            if (level < 2 && optdef.isDetailedOnly()) continue;
            StringBuffer line = new StringBuffer("  ");
            String canonicalName = optdef.getCanonicalName();
            boolean isPattern = optdef.isPattern();
            line.append(prefix);
            line.append(canonicalName);
            if (isPattern) {
                line.append('*');
            }
            String[] names = optdef.getNames();
            for (int n = 0; n < names.length; ++n) {
                String name = names[n];
                if (name.equals(canonicalName)) continue;
                line.append(", ");
                line.append(prefix);
                line.append(name);
                if (!isPattern) continue;
                line.append('*');
            }
            String vmnemonic = optdef.getValueMnemonic();
            if (vmnemonic != null) {
                line.append(' ');
                line.append(vmnemonic);
            }
            if ((padding = 16 - line.length()) < 2) {
                out.println(line);
                line.setLength(0);
                for (p = 0; p < 16; ++p) {
                    line.append(' ');
                }
            } else {
                for (p = 0; p < padding; ++p) {
                    line.append(' ');
                }
            }
            if (optdef.isRequired()) {
                line.append("{required} ");
            }
            line.append(optdef.getDescription());
            out.println(line);
        }
        if (level < 2 && (usageOptDef = this.m_metadata.getUsageOptDef()) != null && usageOptDef.getNames() != null && usageOptDef.getNames().length > 1) {
            out.println();
            out.println("  {use '" + usageOptDef.getNames()[1] + "' option to see detailed usage help}");
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized IOptsParser.IOpts parse(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("null input: args");
        }
        opts = new Opts();
        nv = new String[2];
        pp = new String[1];
        state = 0;
        optdef = null;
        opt = null;
        value = null;
        valueCount = 0;
        a = 0;
        block6: while (a < args.length) {
            av = args[a];
            if (av == null) {
                throw new IllegalArgumentException("null input: args[" + a + "]");
            }
            switch (state) {
                case 0: {
                    if (OptsParser.isOpt(av, valueCount, optdef)) {
                        valueCount = 0;
                        OptsParser.getOptNameAndValue(av, nv);
                        optName = nv[0];
                        optdef = this.m_metadata.getOptDef(optName, pp);
                        if (optdef == null) {
                            opts.addError(this.formatMessage("unknown option '" + optName + "'"));
                            state = 3;
                        } else {
                            canonicalName = OptsParser.getOptCanonicalName(optName, optdef);
                            patternPrefix = pp[0];
                            opt = opts.getOpt(canonicalName);
                            if (optdef.isMergeable()) {
                                if (opt == null) {
                                    opt = new Opt(optName, canonicalName, patternPrefix);
                                    opts.addOpt(opt, optdef, optName);
                                }
                            } else if (opt == null) {
                                opt = new Opt(optName, canonicalName, patternPrefix);
                                opts.addOpt(opt, optdef, optName);
                            } else {
                                opts.addError(this.formatMessage("option '" + optName + "' cannot be specified more than once"));
                                state = 3;
                            }
                            if ((value = nv[1]) == null) {
                                ++a;
                            }
                            state = 1;
                        }
                    } else {
                        state = 2;
                    }
                    ** GOTO lbl83
                }
                case 1: {
                    if (value != null) {
                        valueCount = 1;
                        cardinality = optdef.getValueCardinality();
                        if (cardinality[1] < 1) {
                            opts.addError(this.formatMessage("option '" + opt.getName() + "' does not accept values: '" + value + "'"));
                            state = 3;
                        } else {
                            ++a;
                            opt.addValue(value);
                        }
                    } else {
                        value = args[a];
                        cardinality = optdef.getValueCardinality();
                        if (OptsParser.isOpt(value, valueCount, optdef)) {
                            if (valueCount < cardinality[0]) {
                                opts.addError(this.formatMessage("option '" + opt.getName() + "' does not accept fewer than " + cardinality[0] + " value(s)"));
                                state = 3;
                            } else {
                                state = 0;
                            }
                        } else if (valueCount < cardinality[1]) {
                            ++valueCount;
                            ++a;
                            opt.addValue(value);
                        } else {
                            state = 2;
                        }
                    }
                    value = null;
                    ** GOTO lbl83
                }
                case 2: {
                    if (!OptsParser.isOpt(args[a], valueCount, optdef)) ** GOTO lbl79
                    state = 0;
                    ** GOTO lbl83
lbl79:
                    // 1 sources

                    opts.setFreeArgs(args, a);
                    break block6;
                }
                case 3: {
                    break block6;
                }
lbl83:
                // 6 sources

                default: {
                    continue block6;
                }
            }
        }
        if (a == args.length) {
            if (opt != null) {
                cardinality = optdef.getValueCardinality();
                if (valueCount < cardinality[0]) {
                    opts.addError(this.formatMessage("option '" + opt.getName() + "' does not accept fewer than " + cardinality[0] + " value(s)"));
                }
            } else {
                opts.setFreeArgs(args, a);
            }
        }
        if ((specified = opts.getOpts()) != null) {
            required = new HashSet<E>();
            required.addAll(this.m_metadata.getRequiredOpts());
            for (s = 0; s < specified.length; ++s) {
                required.remove(specified[s].getCanonicalName());
            }
            if (!required.isEmpty()) {
                i = required.iterator();
                while (i.hasNext()) {
                    name = (String)i.next();
                    optdef = this.m_metadata.getOptDef(name, null);
                    requiredUnlessSet = optdef.getRequiredUnlessSet();
                    exempt = false;
                    if (requiredUnlessSet != null) {
                        block9: for (rui = 0; rui < requiredUnlessSet.length; ++rui) {
                            for (s = 0; s < specified.length; ++s) {
                                if (!specified[s].getCanonicalName().equals(requiredUnlessSet[rui])) continue;
                                exempt = true;
                                break block9;
                            }
                        }
                    }
                    if (exempt) continue;
                    opts.addError(this.formatMessage("missing required option '" + name + "'"));
                }
            }
            for (s = 0; s < specified.length; ++s) {
                opt = specified[s];
                optdef = this.m_metadata.getOptDef(opt.getCanonicalName(), null);
                requires = optdef.getRequiresSet();
                if (requires != null) {
                    for (r = 0; r < requires.length; ++r) {
                        if (opts.getOpt(requires[r]) != null) continue;
                        opts.addError(this.formatMessage("option '" + opt.getName() + "' requires option '" + requires[r] + "'"));
                    }
                }
                if ((excludes = optdef.getExcludesSet()) != null) {
                    for (x = 0; x < excludes.length; ++x) {
                        xopt = opts.getOpt(excludes[x]);
                        if (xopt == null) continue;
                        opts.addError(this.formatMessage("option '" + opt.getName() + "' cannot be used with option '" + xopt.getName() + "'"));
                    }
                }
                if (!optdef.isUsage()) continue;
                opts.setUsageRequested(opt.getName().equals(opt.getCanonicalName()) != false ? 1 : 2);
            }
        }
        return opts;
    }

    private static String getOptCanonicalName(String n, OptDef optdef) {
        if (optdef.isPattern()) {
            String canonicalPattern = optdef.getCanonicalName();
            String[] patterns = optdef.getNames();
            for (int p = 0; p < patterns.length; ++p) {
                String pattern = patterns[p];
                if (!n.startsWith(pattern)) continue;
                return canonicalPattern.concat(n.substring(pattern.length()));
            }
            throw new IllegalStateException("failed to detect pattern prefix for [" + n + "]");
        }
        return optdef.getCanonicalName();
    }

    private static boolean isOpt(String av, int valueCount, OptDef optdef) {
        int[] cardinality;
        if (optdef != null && valueCount < (cardinality = optdef.getValueCardinality())[1]) {
            return false;
        }
        for (int p = 0; p < OPT_PREFIXES.length; ++p) {
            if (!av.startsWith(OPT_PREFIXES[p])) continue;
            return av.length() > OPT_PREFIXES[p].length();
        }
        return false;
    }

    private static void getOptNameAndValue(String av, String[] nv) {
        nv[0] = null;
        nv[1] = null;
        for (int p = 0; p < OPT_PREFIXES.length; ++p) {
            if (!av.startsWith(OPT_PREFIXES[p]) || av.length() <= OPT_PREFIXES[p].length()) continue;
            String name = av.substring(OPT_PREFIXES[p].length());
            char separator = '\u0000';
            int sindex = Integer.MAX_VALUE;
            for (int s = 0; s < OPT_VALUE_SEPARATORS.length; ++s) {
                int index = name.indexOf(OPT_VALUE_SEPARATORS[s]);
                if (index <= 0 || index >= sindex) continue;
                separator = OPT_VALUE_SEPARATORS[s];
                sindex = index;
            }
            if (separator != '\u0000') {
                nv[0] = name.substring(0, sindex);
                nv[1] = name.substring(sindex + 1);
            } else {
                nv[0] = name;
            }
            return;
        }
    }

    OptsParser(String metadataResourceName, ClassLoader loader, String[] usageOpts) {
        this(metadataResourceName, loader, null, usageOpts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OptsParser(String metadataResourceName, ClassLoader loader, String msgPrefix, String[] usageOpts) {
        if (metadataResourceName == null) {
            throw new IllegalArgumentException("null input: metadataResourceName");
        }
        this.m_msgPrefix = msgPrefix;
        InputStream in = null;
        try {
            in = ResourceLoader.getResourceAsStream(metadataResourceName, loader);
            if (in == null) {
                throw new IllegalArgumentException("resource [" + metadataResourceName + "] could not be loaded via [" + loader + "]");
            }
            InputStreamReader rin = new InputStreamReader(in);
            this.m_metadata = OptsParser.parseOptDefMetadata(rin, usageOpts);
            Object var8_7 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ignore) {}
    }

    private static OptDefMetadata parseOptDefMetadata(Reader in, String[] usageOpts) {
        int o;
        MetadataParser parser = new MetadataParser();
        OptDef[] optdefs = parser.parse(in);
        OptDefMetadata result = new OptDefMetadata();
        for (o = 0; o < optdefs.length; ++o) {
            result.addOptDef(optdefs[o]);
        }
        if (usageOpts != null) {
            OptDef usage = new OptDef(true);
            usage.setNames(usageOpts);
            usage.setDescription("display usage information");
            usage.setValueCardinality(OptDef.C_ZERO);
            usage.setRequired(false);
            usage.setDetailedOnly(false);
            usage.setMergeable(false);
            result.addOptDef(usage);
        }
        for (o = 0; o < optdefs.length; ++o) {
            String[] excludes;
            OptDef optdef = optdefs[o];
            String[] requires = optdef.getRequiresSet();
            if (requires != null) {
                for (int r = 0; r < requires.length; ++r) {
                    OptDef ropt = result.getOptDef(requires[r], null);
                    if (ropt == null) {
                        throw new IllegalArgumentException("option [" + optdef.getCanonicalName() + "] specifies an unknown option [" + requires[r] + "] in its 'requires' set");
                    }
                    if (ropt != optdef) continue;
                    throw new IllegalArgumentException("option [" + optdef.getCanonicalName() + "] specifies itself in its 'requires' set");
                }
            }
            if ((excludes = optdef.getExcludesSet()) == null) continue;
            for (int x = 0; x < excludes.length; ++x) {
                OptDef xopt = result.getOptDef(excludes[x], null);
                if (xopt == null) {
                    throw new IllegalArgumentException("option [" + optdef.getCanonicalName() + "] specifies an unknown option [" + excludes[x] + "] in its 'excludes' set");
                }
                if (xopt.isRequired()) {
                    throw new IllegalArgumentException("option [" + optdef.getCanonicalName() + "] specifies a required option [" + excludes[x] + "] in its 'excludes' set");
                }
                if (xopt != optdef) continue;
                throw new IllegalArgumentException("option [" + optdef.getCanonicalName() + "] specifies itself in its 'excludes' set");
            }
        }
        return result;
    }

    private String formatMessage(String msg) {
        if (this.m_msgPrefix == null) {
            return msg;
        }
        return this.m_msgPrefix.concat(msg);
    }

    private static final class Token {
        static final int EOF_ID = 0;
        static final int STRING_ID = 1;
        static final int COLON_ID = 2;
        static final int SEMICOLON_ID = 3;
        static final int COMMA_ID = 4;
        static final int LBRACKET_ID = 5;
        static final int RBRACKET_ID = 6;
        static final int OPTIONAL_ID = 7;
        static final int REQUIRED_ID = 8;
        static final int CARD_ID = 9;
        static final int VALUES_ID = 10;
        static final int TEXT_ID = 11;
        static final int REQUIRES_ID = 12;
        static final int EXCLUDES_ID = 13;
        static final int MERGEABLE_ID = 14;
        static final int DETAILEDONLY_ID = 15;
        static final int PATTERN_ID = 16;
        static final int UNLESS_ID = 17;
        static final Token EOF = new Token(0, "<EOF>");
        static final Token COLON = new Token(2, ":");
        static final Token SEMICOLON = new Token(3, ";");
        static final Token COMMA = new Token(4, ",");
        static final Token LBRACKET = new Token(5, "{");
        static final Token RBRACKET = new Token(6, "}");
        static final Token OPTIONAL = new Token(7, "optional");
        static final Token REQUIRED = new Token(8, "required");
        static final Token VALUES = new Token(10, "values");
        static final Token REQUIRES = new Token(12, "requires");
        static final Token EXCLUDES = new Token(13, "excludes");
        static final Token MERGEABLE = new Token(14, "mergeable");
        static final Token DETAILEDONLY = new Token(15, "detailedonly");
        static final Token PATTERN = new Token(16, "pattern");
        static final Token UNLESS = new Token(17, "unless");
        private final int m_ID;
        private final String m_value;

        Token(int ID, String value) {
            if (value == null) {
                throw new IllegalArgumentException("null input: value");
            }
            this.m_ID = ID;
            this.m_value = value;
        }

        int getID() {
            return this.m_ID;
        }

        String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_ID + ": [" + this.m_value + "]";
        }
    }

    static final class MetadataParser {
        private Reader m_in;
        private List m_opts;
        private Token m_token;
        private int m_currentChar;
        private static final Map KEYWORDS;
        private static final OptDef[] EMPTY_OPTDEF_ARRAY;

        MetadataParser() {
        }

        OptDef[] parse(Reader in) {
            OptDef[] result;
            if (in == null) {
                throw new IllegalArgumentException("null input: in");
            }
            this.m_in = in;
            this.nextChar();
            this.nextToken();
            while (this.m_token != Token.EOF) {
                if (this.m_opts == null) {
                    this.m_opts = new ArrayList();
                }
                this.m_opts.add(this.optdef());
            }
            if (this.m_opts == null || this.m_opts.size() == 0) {
                result = EMPTY_OPTDEF_ARRAY;
            } else {
                result = new OptDef[this.m_opts.size()];
                this.m_opts.toArray(result);
            }
            this.m_in = null;
            this.m_opts = null;
            return result;
        }

        OptDef optdef() {
            OptDef optdef = new OptDef(false);
            optdef.setNames(this.optnamelist());
            this.accept(2);
            this.optmetadata(optdef);
            this.accept(3);
            return optdef;
        }

        String[] optnamelist() {
            return this.namelist();
        }

        void optmetadata(OptDef optdef) {
            switch (this.m_token.getID()) {
                case 8: {
                    this.accept();
                    optdef.setRequired(true);
                    if (this.m_token.getID() != 17) break;
                    this.accept();
                    this.accept(5);
                    optdef.setRequiredUnlessSet(this.namelist());
                    this.accept(6);
                    break;
                }
                case 7: {
                    this.accept();
                    optdef.setRequired(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("parse error: invalid token " + this.m_token + ", expected " + Token.REQUIRED + " or " + Token.OPTIONAL);
                }
            }
            this.accept(4);
            if (this.m_token.getID() == 14) {
                this.accept();
                optdef.setMergeable(true);
                this.accept(4);
            }
            if (this.m_token.getID() == 15) {
                this.accept();
                optdef.setDetailedOnly(true);
                this.accept(4);
            }
            if (this.m_token.getID() == 16) {
                this.accept();
                optdef.setPattern(true);
                this.accept(4);
            }
            this.accept(10);
            this.accept(2);
            optdef.setValueCardinality(this.cardinality());
            this.accept(4);
            if (this.m_token.getID() == 1) {
                optdef.setValueMnemonic(this.m_token.getValue());
                this.accept();
                this.accept(4);
            }
            if (this.m_token.getID() == 12) {
                this.accept();
                this.accept(5);
                optdef.setRequiresSet(this.namelist());
                this.accept(6);
                this.accept(4);
            }
            if (this.m_token.getID() == 13) {
                this.accept();
                this.accept(5);
                optdef.setExcludesSet(this.namelist());
                this.accept(6);
                this.accept(4);
            }
            optdef.setDescription(this.accept(11).getValue());
        }

        int[] cardinality() {
            Token result = this.accept(9);
            if ("0".equals(result.getValue())) {
                return OptDef.C_ZERO;
            }
            if ("1".equals(result.getValue())) {
                return OptDef.C_ONE;
            }
            return OptDef.C_ZERO_OR_ONE;
        }

        String[] namelist() {
            ArrayList<String> _result = new ArrayList<String>();
            _result.add(this.accept(1).getValue());
            while (this.m_token.getID() == 4) {
                this.accept();
                _result.add(this.accept(1).getValue());
            }
            String[] result = new String[_result.size()];
            _result.toArray(result);
            return result;
        }

        Token accept() {
            Token current = this.m_token;
            this.nextToken();
            return current;
        }

        Token accept(int tokenID) {
            Token current = this.m_token;
            if (this.m_token.getID() != tokenID) {
                throw new IllegalArgumentException("parse error: invalid token [" + this.m_token + "], expected type [" + tokenID + "]");
            }
            this.nextToken();
            return current;
        }

        void nextToken() {
            this.consumeWS();
            switch (this.m_currentChar) {
                case -1: {
                    this.m_token = Token.EOF;
                    break;
                }
                case 58: {
                    this.nextChar();
                    this.m_token = Token.COLON;
                    break;
                }
                case 59: {
                    this.nextChar();
                    this.m_token = Token.SEMICOLON;
                    break;
                }
                case 44: {
                    this.nextChar();
                    this.m_token = Token.COMMA;
                    break;
                }
                case 123: {
                    this.nextChar();
                    this.m_token = Token.LBRACKET;
                    break;
                }
                case 125: {
                    this.nextChar();
                    this.m_token = Token.RBRACKET;
                    break;
                }
                case 48: {
                    this.nextChar();
                    this.m_token = new Token(9, "0");
                    break;
                }
                case 49: {
                    this.nextChar();
                    this.m_token = new Token(9, "1");
                    break;
                }
                case 63: {
                    this.nextChar();
                    this.m_token = new Token(9, "?");
                    break;
                }
                case 39: {
                    StringBuffer value = new StringBuffer();
                    this.nextChar();
                    while (this.m_currentChar != 39) {
                        value.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    this.nextChar();
                    this.m_token = new Token(1, value.toString());
                    break;
                }
                case 34: {
                    StringBuffer value = new StringBuffer();
                    this.nextChar();
                    while (this.m_currentChar != 34) {
                        value.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    this.nextChar();
                    this.m_token = new Token(11, value.toString());
                    break;
                }
                default: {
                    StringBuffer value = new StringBuffer();
                    while (Character.isLetter((char)this.m_currentChar)) {
                        value.append((char)this.m_currentChar);
                        this.nextChar();
                    }
                    Token token = (Token)KEYWORDS.get(value.toString());
                    if (token == null) {
                        throw new IllegalArgumentException("parse error: unrecognized keyword [" + value + "]");
                    }
                    this.m_token = token;
                }
            }
        }

        private void consumeWS() {
            if (this.m_currentChar == -1) {
                return;
            }
            while (Character.isWhitespace((char)this.m_currentChar)) {
                this.nextChar();
            }
        }

        private void nextChar() {
            try {
                this.m_currentChar = this.m_in.read();
            }
            catch (IOException ioe) {
                throw new RuntimeException("I/O error while parsing: " + ioe);
            }
        }

        static {
            EMPTY_OPTDEF_ARRAY = new OptDef[0];
            KEYWORDS = new HashMap(17);
            KEYWORDS.put(Token.OPTIONAL.getValue(), Token.OPTIONAL);
            KEYWORDS.put(Token.REQUIRED.getValue(), Token.REQUIRED);
            KEYWORDS.put(Token.VALUES.getValue(), Token.VALUES);
            KEYWORDS.put(Token.REQUIRES.getValue(), Token.REQUIRES);
            KEYWORDS.put(Token.EXCLUDES.getValue(), Token.EXCLUDES);
            KEYWORDS.put(Token.MERGEABLE.getValue(), Token.MERGEABLE);
            KEYWORDS.put(Token.DETAILEDONLY.getValue(), Token.DETAILEDONLY);
            KEYWORDS.put(Token.PATTERN.getValue(), Token.PATTERN);
            KEYWORDS.put(Token.UNLESS.getValue(), Token.UNLESS);
        }
    }

    static final class OptDefMetadata {
        final List m_optdefs = new ArrayList();
        final Map m_optdefMap = new HashMap();
        final Set m_requiredOpts = new HashSet();
        final Map m_patternOptDefMap = new HashMap();
        private OptDef m_usageOptDef;

        OptDefMetadata() {
        }

        OptDef getOptDef(String name, String[] prefixout) {
            OptDef result;
            if (name == null) {
                throw new IllegalArgumentException("null input: name");
            }
            if (prefixout != null) {
                prefixout[0] = null;
            }
            if ((result = (OptDef)this.m_optdefMap.get(name)) == null) {
                Iterator ps = this.m_patternOptDefMap.entrySet().iterator();
                while (ps.hasNext()) {
                    Map.Entry entry = ps.next();
                    String pattern = (String)entry.getKey();
                    if (!name.startsWith(pattern)) continue;
                    if (prefixout != null) {
                        prefixout[0] = pattern;
                    }
                    result = (OptDef)entry.getValue();
                    break;
                }
            }
            return result;
        }

        Iterator getOptDefs() {
            return this.m_optdefs.iterator();
        }

        OptDef getPatternOptDefs(String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("null input: pattern");
            }
            return (OptDef)this.m_patternOptDefMap.get(pattern);
        }

        Set getRequiredOpts() {
            return this.m_requiredOpts;
        }

        OptDef getUsageOptDef() {
            return this.m_usageOptDef;
        }

        void addOptDef(OptDef optdef) {
            if (optdef == null) {
                throw new IllegalArgumentException("null input: optdef");
            }
            Map map = optdef.isPattern() ? this.m_patternOptDefMap : this.m_optdefMap;
            String[] names = optdef.getNames();
            for (int n = 0; n < names.length; ++n) {
                if (map.containsKey(names[n])) {
                    throw new IllegalArgumentException("duplicate option name [" + names[n] + "]");
                }
                map.put(names[n], optdef);
            }
            this.m_optdefs.add(optdef);
            if (optdef.isRequired()) {
                this.m_requiredOpts.add(optdef.getCanonicalName());
            }
            if (optdef.isUsage()) {
                if (this.m_usageOptDef != null) {
                    throw new IllegalArgumentException("usage optdef set already");
                }
                this.m_usageOptDef = optdef;
            }
        }
    }

    static final class OptDef {
        static final int[] C_ZERO = new int[]{0, 0};
        static final int[] C_ONE = new int[]{1, 1};
        static final int[] C_ZERO_OR_ONE = new int[]{0, 1};
        static final int[] C_ZERO_OR_MORE = new int[]{0, Integer.MAX_VALUE};
        static final int[] C_ONE_OR_MORE = new int[]{1, Integer.MAX_VALUE};
        private final boolean m_usage;
        private String[] m_names;
        private boolean m_required;
        private String[] m_requiredUnlessSet;
        private String m_valueMnemonic;
        private boolean m_mergeable;
        private boolean m_detailedOnly;
        private boolean m_pattern;
        private int[] m_valueCardinality;
        private String[] m_requiresSet;
        private String[] m_excludesSet;
        private String m_description;

        OptDef(boolean usage) {
            this.m_usage = usage;
        }

        boolean isUsage() {
            return this.m_usage;
        }

        String getCanonicalName() {
            return this.m_names[0];
        }

        String[] getNames() {
            return this.m_names;
        }

        boolean isRequired() {
            return this.m_required;
        }

        String[] getRequiredUnlessSet() {
            return this.m_requiredUnlessSet;
        }

        String getValueMnemonic() {
            return this.m_valueMnemonic;
        }

        boolean isMergeable() {
            return this.m_mergeable;
        }

        boolean isDetailedOnly() {
            return this.m_detailedOnly;
        }

        boolean isPattern() {
            return this.m_pattern;
        }

        int[] getValueCardinality() {
            return this.m_valueCardinality;
        }

        String[] getRequiresSet() {
            return this.m_requiresSet;
        }

        String[] getExcludesSet() {
            return this.m_excludesSet;
        }

        String getDescription() {
            return this.m_description;
        }

        void setNames(String[] names) {
            if (names == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_names = names;
        }

        void setRequired(boolean required) {
            this.m_required = required;
        }

        void setRequiredUnlessSet(String[] names) {
            if (names == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_requiredUnlessSet = names.length > 0 ? names : null;
        }

        void setValueMnemonic(String mnemonic) {
            if (mnemonic == null) {
                throw new IllegalArgumentException("null input: mnemonic");
            }
            this.m_valueMnemonic = mnemonic;
        }

        void setMergeable(boolean mergeable) {
            this.m_mergeable = mergeable;
        }

        void setDetailedOnly(boolean detailedOnly) {
            this.m_detailedOnly = detailedOnly;
        }

        void setPattern(boolean pattern) {
            this.m_pattern = pattern;
        }

        void setValueCardinality(int[] cardinality) {
            if (cardinality == null || cardinality.length != 2) {
                throw new IllegalArgumentException("null or invalid input: cardinality");
            }
            this.m_valueCardinality = cardinality;
        }

        void setRequiresSet(String[] names) {
            if (names == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_requiresSet = names.length > 0 ? names : null;
        }

        void setExcludesSet(String[] names) {
            if (names == null) {
                throw new IllegalArgumentException("null input: names");
            }
            this.m_excludesSet = names.length > 0 ? names : null;
        }

        void setDescription(String description) {
            if (description == null) {
                throw new IllegalArgumentException("null input: description");
            }
            this.m_description = description;
        }
    }

    static final class Opts
    implements IOptsParser.IOpts {
        private final List m_opts = new ArrayList();
        private final Map m_nameMap = new HashMap();
        private final Map m_patternMap = new HashMap();
        private String[] m_freeArgs;
        private List m_errors;
        private int m_usageRequestLevel;
        private static final int DEFAULT_ERROR_WIDTH = 80;
        private static final IOptsParser.IOpt[] EMPTY_OPT_ARRAY = new IOptsParser.IOpt[0];

        public int usageRequestLevel() {
            return this.m_usageRequestLevel;
        }

        public void error(PrintWriter out, int width) {
            if (this.hasErrors()) {
                Iterator i = this.m_errors.iterator();
                while (i.hasNext()) {
                    out.println(i.next());
                }
            }
        }

        public String[] getFreeArgs() {
            if (this.hasErrors()) {
                throw new IllegalStateException(this.errorsToString());
            }
            return this.m_freeArgs;
        }

        public IOptsParser.IOpt[] getOpts() {
            if (this.hasErrors()) {
                return null;
            }
            if (this.m_opts.isEmpty()) {
                return EMPTY_OPT_ARRAY;
            }
            IOptsParser.IOpt[] result = new IOptsParser.IOpt[this.m_opts.size()];
            this.m_opts.toArray(result);
            return result;
        }

        public IOptsParser.IOpt[] getOpts(String pattern) {
            if (this.hasErrors()) {
                return null;
            }
            List patternOpts = (List)this.m_patternMap.get(pattern);
            if (patternOpts == null || patternOpts.isEmpty()) {
                return EMPTY_OPT_ARRAY;
            }
            IOptsParser.IOpt[] result = new IOptsParser.IOpt[patternOpts.size()];
            patternOpts.toArray(result);
            return result;
        }

        public boolean hasArg(String name) {
            if (this.hasErrors()) {
                throw new IllegalStateException(this.errorsToString());
            }
            return this.m_nameMap.containsKey(name);
        }

        Opts() {
        }

        void addOpt(Opt opt, OptDef optdef, String occuranceName) {
            boolean isPattern;
            if (opt == null) {
                throw new IllegalArgumentException("null input: opt");
            }
            if (optdef == null) {
                throw new IllegalArgumentException("null input: optdef");
            }
            if (occuranceName == null) {
                throw new IllegalArgumentException("null input: occuranceName");
            }
            this.m_opts.add(opt);
            String[] names = optdef.getNames();
            boolean bl = isPattern = opt.getPatternPrefix() != null;
            if (isPattern) {
                String unprefixedName = occuranceName.substring(opt.getPatternPrefix().length());
                for (int n = 0; n < names.length; ++n) {
                    this.m_nameMap.put(names[n].concat(unprefixedName), opt);
                }
                String canonicalPattern = optdef.getCanonicalName();
                ArrayList<Opt> patternList = (ArrayList<Opt>)this.m_patternMap.get(canonicalPattern);
                if (patternList == null) {
                    patternList = new ArrayList<Opt>();
                    for (int n = 0; n < names.length; ++n) {
                        this.m_patternMap.put(names[n], patternList);
                    }
                }
                patternList.add(opt);
            } else {
                for (int n = 0; n < names.length; ++n) {
                    this.m_nameMap.put(names[n], opt);
                }
            }
        }

        Opt getOpt(String occuranceName) {
            if (occuranceName == null) {
                throw new IllegalArgumentException("null input: occuranceName");
            }
            return (Opt)this.m_nameMap.get(occuranceName);
        }

        void setFreeArgs(String[] args, int start) {
            if (args == null) {
                throw new IllegalArgumentException("null input: args");
            }
            if (start < 0 || start > args.length) {
                throw new IllegalArgumentException("invalid start index: " + start);
            }
            this.m_freeArgs = new String[args.length - start];
            System.arraycopy(args, start, this.m_freeArgs, 0, this.m_freeArgs.length);
        }

        void setUsageRequested(int level) {
            this.m_usageRequestLevel = level;
        }

        void addError(String msg) {
            if (msg != null) {
                if (this.m_errors == null) {
                    this.m_errors = new ArrayList();
                }
                this.m_errors.add(msg);
            }
        }

        boolean hasErrors() {
            return this.m_errors != null && !this.m_errors.isEmpty();
        }

        String errorsToString() {
            if (!this.hasErrors()) {
                return "<no errors>";
            }
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            this.error(pw, 80);
            pw.flush();
            return caw.toString();
        }
    }

    static final class Opt
    implements IOptsParser.IOpt {
        private final String m_name;
        private final String m_canonicalName;
        private final String m_patternPrefix;
        private ArrayList m_values;

        public String getName() {
            return this.m_name;
        }

        public String getCanonicalName() {
            return this.m_canonicalName;
        }

        public int getValueCount() {
            if (this.m_values == null) {
                return 0;
            }
            return this.m_values.size();
        }

        public String getFirstValue() {
            if (this.m_values == null) {
                return null;
            }
            return (String)this.m_values.get(0);
        }

        public String[] getValues() {
            if (this.m_values == null) {
                return IConstants.EMPTY_STRING_ARRAY;
            }
            String[] result = new String[this.m_values.size()];
            this.m_values.toArray(result);
            return result;
        }

        public String getPatternPrefix() {
            return this.m_patternPrefix;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(this.m_name);
            if (!this.m_canonicalName.equals(this.m_name)) {
                s.append(" [" + this.m_canonicalName + "]");
            }
            if (this.m_values != null) {
                s.append(": ");
                s.append(this.m_values);
            }
            return s.toString();
        }

        Opt(String name, String canonicalName, String patternPrefix) {
            this.m_name = name;
            this.m_canonicalName = canonicalName;
            this.m_patternPrefix = patternPrefix;
        }

        void addValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("null input: value");
            }
            if (this.m_values == null) {
                this.m_values = new ArrayList();
            }
            this.m_values.add(value);
        }
    }
}

