/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.AgentDeploymentException;
import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentApplicationBase;
import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentDeploymentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentApplicationV2Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentV2Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.WarningBypassingErrorHandler;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.InstanceInfo;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.cloudfoundry.client.lib.domain.Staging;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class CFCloudAgentDeploymentV2Impl
extends CFCloudAgentDeploymentBase {
    private static final int DEFAULT_MEMORY = 512;
    private final CloudFoundryClient myClient;
    private final CloudAgentLoggingHandler myLoggingHandler;

    public CFCloudAgentDeploymentV2Impl(CFCloudAgentV2Impl agent, CloudFoundryClient client, CFCloudAgentDeploymentConfiguration config, CloudAgentLoggingHandler loggingHandler) {
        super((CFCloudAgentApplicationBase)new CFCloudAgentApplicationV2Impl(agent, client, config.getDeploymentName()), config);
        this.myClient = client;
        this.myLoggingHandler = loggingHandler;
    }

    protected CFCloudAgentV2Impl getAgent() {
        return (CFCloudAgentV2Impl)super.getAgent();
    }

    private void println(String line) {
        this.myLoggingHandler.println(line);
    }

    protected void doDeploy() throws IOException {
        CFCloudAgentDeploymentConfiguration config = this.getConfig();
        String deploymentName = this.getDeploymentName();
        List serviceNames = null;
        List<String> uris = Collections.singletonList(config.getAppUrl());
        Staging staging = new Staging();
        this.println("Creating...");
        this.myClient.createApplication(deploymentName, staging, Integer.valueOf(512), uris, serviceNames);
        this.println("Uploading...");
        this.myClient.uploadApplication(deploymentName, config.getFile());
        this.println("Applying settings...");
        this.setAppSettings(config.getApplicationSettings());
        this.println("Starting...");
        StartingInfo startingInfo = this.doStart();
        this.showStagingStatus(startingInfo);
        this.println("Checking status...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning() throws AgentDeploymentException {
        CloudApplication app = this.myClient.getApplication(this.getDeploymentName());
        if (app == null) {
            throw new AgentDeploymentException("Application not found");
        }
        WarningBypassingErrorHandler errorHandler = this.getAgent().getResponseErrorHandler();
        try {
            errorHandler.addExpectedStatus(HttpStatus.BAD_REQUEST);
            List<InstanceInfo> instances = this.getApplicationInstances(app);
            if (instances != null) {
                int expectedInstances = CFCloudAgentDeploymentV2Impl.getExpectedInstances(instances);
                int runningInstances = CFCloudAgentDeploymentV2Impl.getRunningInstances(instances);
                int flappingInstances = CFCloudAgentDeploymentV2Impl.getFlappingInstances(instances);
                this.showInstancesStatus(instances, runningInstances, expectedInstances);
                if (flappingInstances > 0) {
                    throw new AgentDeploymentException("Cannot start instances");
                }
                if (runningInstances == expectedInstances) {
                    boolean bl = true;
                    return bl;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            errorHandler.clearExpectedStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showStagingStatus(StartingInfo startingInfo) {
        if (startingInfo == null) {
            return;
        }
        WarningBypassingErrorHandler errorHandler = this.getAgent().getResponseErrorHandler();
        try {
            errorHandler.addExpectedStatus(HttpStatus.NOT_FOUND);
            int offset = 0;
            String staging = this.myClient.getStagingLogs(startingInfo, offset);
            while (staging != null) {
                this.myLoggingHandler.println(staging);
                staging = this.myClient.getStagingLogs(startingInfo, offset += staging.length());
            }
        }
        finally {
            errorHandler.clearExpectedStatus();
        }
    }

    protected void showInstancesStatus(List<InstanceInfo> instances, int runningInstances, int expectedInstances) {
        HashMap<String, Integer> stateCounts = new HashMap<String, Integer>();
        for (InstanceInfo instance : instances) {
            String state = instance.getState().toString();
            Integer stateCount = (Integer)stateCounts.get(state);
            if (stateCount == null) {
                stateCounts.put(state, 1);
                continue;
            }
            stateCounts.put(state, stateCount + 1);
        }
        ArrayList<String> stateStrings = new ArrayList<String>();
        for (Map.Entry stateCount : stateCounts.entrySet()) {
            stateStrings.add(String.format("%s %s", stateCount.getValue(), ((String)stateCount.getKey()).toLowerCase()));
        }
        this.println(String.format(" %d of %d instances running (%s)", runningInstances, expectedInstances, StringUtils.collectionToCommaDelimitedString(stateStrings)));
    }

    private List<InstanceInfo> getApplicationInstances(CloudApplication app) {
        InstancesInfo instancesInfo = this.myClient.getApplicationInstances(app);
        if (instancesInfo != null) {
            return instancesInfo.getInstances();
        }
        return null;
    }

    private static int getExpectedInstances(List<InstanceInfo> instances) {
        return instances == null ? 0 : instances.size();
    }

    private static int getRunningInstances(List<InstanceInfo> instances) {
        return CFCloudAgentDeploymentV2Impl.getInstanceCount(instances, InstanceState.RUNNING);
    }

    private static int getFlappingInstances(List<InstanceInfo> instances) {
        return CFCloudAgentDeploymentV2Impl.getInstanceCount(instances, InstanceState.FLAPPING);
    }

    private static int getInstanceCount(List<InstanceInfo> instances, InstanceState state) {
        int count = 0;
        if (instances != null) {
            for (InstanceInfo instance : instances) {
                if (!instance.getState().equals((Object)state)) continue;
                ++count;
            }
        }
        return count;
    }

    private StartingInfo doStart() {
        return this.myClient.startApplication(this.getDeploymentName());
    }

    private void setAppSettings(CFAppSettings settings) {
        String deploymentName = this.getDeploymentName();
        Integer memory = settings.getMemory();
        Integer instances = settings.getInstances();
        if (memory != null) {
            this.myClient.updateApplicationMemory(deploymentName, memory.intValue());
        }
        if (instances != null) {
            this.myClient.updateApplicationInstances(deploymentName, instances.intValue());
        }
    }
}

