/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.index.DuplicatesInspectionBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspection
extends DuplicatesInspectionBase {
    protected LocalQuickFix createNavigateToDupeFix(final @NotNull VirtualFile file, final int offsetInOtherFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspection", "createNavigateToDupeFix"));
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                if ("Navigate to duplicate" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesInspection$1", "getName"));
                }
                return "Navigate to duplicate";
            }

            @NotNull
            public String getFamilyName() {
                if ("Navigate" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesInspection$1", "getFamilyName"));
                }
                return "Navigate";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/index/DuplicatesInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/dupLocator/index/DuplicatesInspection$1", "applyFix"));
                }
                new OpenFileDescriptor(project, file, offsetInOtherFile).navigate(true);
            }
        };
    }

    protected LocalQuickFix createShowOtherDupesFix(final VirtualFile file, final int offset, final int hashOfDuplicate, final int hashOfDuplicate2, Project project) {
        return new LocalQuickFix(){
            private String myTitle;

            @Nls
            @NotNull
            public String getName() {
                if ("View duplicates like this" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesInspection$2", "getName"));
                }
                return "View duplicates like this";
            }

            @NotNull
            public String getFamilyName() {
                if ("Navigate" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesInspection$2", "getFamilyName"));
                }
                return "Navigate";
            }

            public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/index/DuplicatesInspection$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/dupLocator/index/DuplicatesInspection$2", "applyFix"));
                }
                UsageViewPresentation presentation = new UsageViewPresentation();
                String title = this.buildTitle();
                presentation.setUsagesString(title);
                presentation.setTabName(title);
                presentation.setTabText(title);
                final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                presentation.setScopeText(scope.getDisplayName());
                UsageViewManager.getInstance((Project)project).searchAndShowUsages(new UsageTarget[]{new UsageTarget(){

                    public void findUsages() {
                    }

                    public void findUsagesInEditor(@NotNull FileEditor editor) {
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/dupLocator/index/DuplicatesInspection$2$1", "findUsagesInEditor"));
                        }
                    }

                    public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspection$2$1", "highlightUsages"));
                        }
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/dupLocator/index/DuplicatesInspection$2$1", "highlightUsages"));
                        }
                    }

                    public boolean isValid() {
                        return true;
                    }

                    public boolean isReadOnly() {
                        return true;
                    }

                    @Nullable
                    public VirtualFile[] getFiles() {
                        return null;
                    }

                    public void update() {
                    }

                    @Nullable
                    public String getName() {
                        return this.buildTitle();
                    }

                    @Nullable
                    public ItemPresentation getPresentation() {
                        return new PresentationData(this.getName(), "", null, null);
                    }

                    public void navigate(boolean requestFocus) {
                        new OpenFileDescriptor(project, file, offset).navigate(requestFocus);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return this.canNavigate();
                    }
                }}, (Factory)new Factory<UsageSearcher>(){

                    public UsageSearcher create() {
                        return new UsageSearcher(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void generate(final @NotNull Processor<Usage> processor) {
                                if (processor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/dupLocator/index/DuplicatesInspection$2$2$1", "generate"));
                                }
                                Collection files = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

                                    public Collection<VirtualFile> compute() {
                                        return FileBasedIndex.getInstance().getContainingFiles(DuplicatesIndex.NAME, (Object)hashOfDuplicate, scope);
                                    }
                                });
                                for (VirtualFile file : files) {
                                    AccessToken accessToken = ReadAction.start();
                                    try {
                                        DuplicatesProfile profile;
                                        PsiFile psiFile;
                                        if (!file.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null || (profile = DuplicatesIndex.findDuplicatesProfile((FileType)psiFile.getFileType())) == null) continue;
                                        if (profile instanceof LightDuplicateProfile) {
                                            LighterAST ast = psiFile.getNode().getLighterAST();
                                            assert (ast != null);
                                            ((LightDuplicateProfile)profile).process(ast, new LightDuplicateProfile.Callback(){

                                                public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                                                    if (ast == null) {
                                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesInspection$2$2$1$2", "process"));
                                                    }
                                                    if (nodes == null) {
                                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dupLocator/index/DuplicatesInspection$2$2$1$2", "process"));
                                                    }
                                                    if (hash != hashOfDuplicate) {
                                                        return;
                                                    }
                                                    if (hash2 != hashOfDuplicate2) {
                                                        return;
                                                    }
                                                    processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, nodes[0].getStartOffset(), nodes[nodes.length - 1].getEndOffset())));
                                                }
                                            });
                                            continue;
                                        }
                                        final DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
                                        profile.createVisitor(new FragmentsCollector(){

                                            public void add(int hash, int cost, @Nullable PsiFragment frag) {
                                                if (hash != hashOfDuplicate || !DuplicatesIndex.isIndexedFragment((PsiFragment)frag, (int)cost, (DuplicatesProfile)profile, (DuplocatorState)state)) {
                                                    return;
                                                }
                                                processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, frag.getStartOffset(), frag.getEndOffset())));
                                            }
                                        }, true).visitNode((PsiElement)psiFile);
                                    }
                                    finally {
                                        accessToken.finish();
                                    }
                                }
                            }
                        };
                    }
                }, false, false, presentation, null);
            }

            @NotNull
            private String buildTitle() {
                if (this.myTitle == null) {
                    this.myTitle = "Duplicate code like in " + file.getName() + ":" + offset;
                }
                String string = this.myTitle;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesInspection$2", "buildTitle"));
                }
                return string;
            }
        };
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(DupLocatorBundle.message((String)"skip.duplicates.in.generated.code", (Object[])new Object[0]), (InspectionProfileEntry)this, "myFilterOutGeneratedCode");
    }
}

