/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.lang.aspectj.build.AjCompilerConfigurable;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AjIdeaCompiler
implements BackendCompiler {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.aspectj.compiler.ajc.AjcCompiler");
    private static final int AJC_TEST_TIMEOUT = 30000;
    private static final Set<FileType> COMPILABLE_TYPES = ContainerUtil.newTroveSet((Object[])new FileType[]{StdFileTypes.JAVA, AspectJFileType.INSTANCE});
    private final Project myProject;

    public AjIdeaCompiler(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjIdeaCompiler", "getCompilableFileTypes"));
        }
        return set;
    }

    @NotNull
    public String getId() {
        if ("ajc" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjIdeaCompiler", "getId"));
        }
        return "ajc";
    }

    @NotNull
    public String getPresentableName() {
        String string = AspectJBundle.message("compiler.ajc.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjIdeaCompiler", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Configurable createConfigurable() {
        AjCompilerConfigurable ajCompilerConfigurable = new AjCompilerConfigurable(AjIdeaCompilerSettings.getSettings(this.myProject), this.myProject);
        if (ajCompilerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjIdeaCompiler", "createConfigurable"));
        }
        return ajCompilerConfigurable;
    }

    public static String testCompiler(Project project, String ajToolsJarPath, String heapSize) throws IOException {
        String result;
        ArrayList<String> command = new ArrayList<String>();
        command.add("-version");
        Process process = AjIdeaCompiler.launchCompiler(project, ajToolsJarPath, heapSize, command);
        CapturingProcessHandler handler = new CapturingProcessHandler(process);
        ProcessOutput output = handler.runProcess(30000);
        if (output.isTimeout()) {
            throw new IOException("Timeout");
        }
        String out = output.getStdout().trim();
        String err = output.getStderr().trim();
        if (out.length() > 0) {
            result = err.length() > 0 ? err + "\n\n" + out : out;
        } else if (err.length() > 0) {
            result = err;
        } else {
            throw new IOException("Empty output");
        }
        if (output.getExitCode() != 0) {
            throw new IOException(result);
        }
        return out;
    }

    private static Process launchCompiler(Project project, String ajToolsJarPath, String heapSize, List<String> command) throws IOException {
        Sdk jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (jdk == null || !(jdk.getSdkType() instanceof JavaSdkType)) {
            throw new IllegalArgumentException(AspectJBundle.message("compiler.ajc.no.jdk", new Object[0]));
        }
        JavaSdkType sdkType = (JavaSdkType)jdk.getSdkType();
        String toolsJarPath = sdkType.getToolsPath(jdk);
        if (toolsJarPath == null) {
            throw new IllegalArgumentException(AspectJBundle.message("compiler.ajc.no.tools.jar", new Object[0]));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(sdkType.getVMExecutablePath(jdk));
        commandLine.addParameter("-ea");
        if (!StringUtil.isEmpty((String)heapSize)) {
            commandLine.addParameter(StringUtil.join((String[])new String[]{"-Xmx", heapSize, "m"}));
        }
        commandLine.addParameter("-classpath");
        commandLine.addParameter(StringUtil.join(Arrays.asList(toolsJarPath, ajToolsJarPath), (String)File.pathSeparator));
        commandLine.addParameter("org.aspectj.tools.ajc.Main");
        commandLine.addParameters(command);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && baseDir.isDirectory()) {
            commandLine.setWorkDirectory(baseDir.getPath());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("call: " + commandLine.getCommandLineString());
        }
        try {
            return commandLine.createProcess();
        }
        catch (ExecutionException e) {
            throw e.toIOException();
        }
    }
}

