/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.presentation.AspectJPresentationUtil;
import com.intellij.lang.aspectj.psi.stub.PsiAspectStub;
import com.intellij.lang.aspectj.psi.util.AjPsiUtil;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAspectImpl
extends PsiClassImpl
implements PsiAspect {
    private static final TokenSet INNER_CLASSES_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.CLASS, AspectJElementType.ASPECT});
    private static final String HAS_ASPECT = "hasAspect";
    private static final String ASPECT_OF = "aspectOf";

    public PsiAspectImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "<init>"));
        }
        super(astNode);
    }

    public PsiAspectImpl(PsiAspectStub stub) {
        super((PsiClassStub)stub, AspectJElementType.ASPECT);
    }

    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(INNER_CLASSES_SET, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "getOwnInnerClasses"));
        }
        return list;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "accept"));
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitAspect(this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiModifierList modList;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "processDeclarations"));
        }
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) && (modList = this.getModifierList()) != null && !modList.hasModifierProperty("abstract")) {
            PsiMethod candidate;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if ((nameHint == null || HAS_ASPECT.equals(nameHint.getName(state))) && (candidate = this.getHasAspectMethod()) != null && !processor.execute((PsiElement)candidate, state)) {
                return false;
            }
            if ((nameHint == null || ASPECT_OF.equals(nameHint.getName(state))) && (candidate = this.getAspectOfMethod()) != null && !processor.execute((PsiElement)candidate, state)) {
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    private PsiMethod getHasAspectMethod() {
        CachedValuesManager.getManager((Project)this.getProject());
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod>(){

            public CachedValueProvider.Result<PsiMethod> compute() {
                PsiMethod method = InterTypeResolveUtil.createArtificialMethod("public static boolean hasAspect() {}", PsiAspectImpl.this);
                return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{PsiAspectImpl.this});
            }
        });
    }

    @Nullable
    private synchronized PsiMethod getAspectOfMethod() {
        CachedValuesManager.getManager((Project)this.getProject());
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod>(){

            public CachedValueProvider.Result<PsiMethod> compute() {
                PsiIdentifier identifier = PsiAspectImpl.this.getNameIdentifier();
                if (identifier != null) {
                    String text = "public static " + identifier.getText() + " aspectOf() {}";
                    PsiMethod method = InterTypeResolveUtil.createArtificialMethod(text, PsiAspectImpl.this);
                    return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{identifier});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiAspectImpl.this});
            }
        });
    }

    @Override
    @NotNull
    public List<PsiInterTypeDeclaration> getInterTypeDeclarations() {
        List<PsiInterTypeDeclaration> list = AjPsiUtil.getChildrenOfType((PsiElement)this, PsiInterTypeDeclaration.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl", "getInterTypeDeclarations"));
        }
        return list;
    }

    @Override
    public boolean isPrivileged() {
        PsiModifierList modList = this.getModifierList();
        if (modList == null) {
            return false;
        }
        ASTNode node = modList.getNode();
        return node != null && node.findChildByType(AspectJTokenType.PRIVILEGED_KEYWORD) != null;
    }

    public Icon getIcon(int flags) {
        return AspectJPresentationUtil.getAspectIcon(this, flags);
    }

    public String toString() {
        return "PsiAspect:" + this.getName();
    }
}

