/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.impl.PsiAspectImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiAspectStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiAspectStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.AspectElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AjAspectElementType
extends AjStubElementType<PsiAspectStub, PsiAspect> {
    public AjAspectElementType() {
        super("ASPECT");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        AspectElement aspectElement = new AspectElement();
        if (aspectElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "createCompositeNode"));
        }
        return aspectElement;
    }

    public PsiAspect createPsi(@NotNull PsiAspectStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "createPsi"));
        }
        return new PsiAspectImpl(stub);
    }

    @Override
    public PsiAspect createPsi(ASTNode node) {
        return new PsiAspectImpl(node);
    }

    public PsiAspectStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String qualifiedName = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName = pkg.length() > 0 ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                qualifiedName = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiAspectStubImpl(parentStub, name, qualifiedName, flags);
    }

    public void serialize(@NotNull PsiAspectStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)((PsiAspectStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiAspectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        StringRef qualifiedName = dataStream.readName();
        byte flags = dataStream.readByte();
        PsiAspectStubImpl psiAspectStubImpl = new PsiAspectStubImpl(parentStub, StringRef.toString((StringRef)name), StringRef.toString((StringRef)qualifiedName), flags);
        if (psiAspectStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "deserialize"));
        }
        return psiAspectStubImpl;
    }

    public void indexStub(@NotNull PsiAspectStub stub, @NotNull IndexSink sink) {
        String qualifiedName;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/aspectj/psi/stub/AjAspectElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name);
        }
        if ((qualifiedName = stub.getQualifiedName()) != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_FQN, (Object)qualifiedName.hashCode());
        }
    }

    public String getId(PsiAspectStub stub) {
        String name = stub.getName();
        if (name != null) {
            return name;
        }
        return super.getId((StubElement)stub);
    }
}

