/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.util;

import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private static final String RT_SIGNATURE_CLASS = "org.aspectj.lang.JoinPoint";
    private static final Collection<String> LIB_LEVELS = ContainerUtil.newTroveSet((Object[])new String[]{"application", "project"});

    private LibraryUtil() {
    }

    public static boolean hasAjRunTime(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return facade.findClass(RT_SIGNATURE_CLASS, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @NotNull
    public static Map<AjPathEntries.Entry, Object> mapEntries(@NotNull List<AjPathEntries.Entry> entries, @NotNull Project project) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/lang/aspectj/util/LibraryUtil", "mapEntries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/util/LibraryUtil", "mapEntries"));
        }
        if (entries.isEmpty()) {
            Map<AjPathEntries.Entry, Object> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/util/LibraryUtil", "mapEntries"));
            }
            return map;
        }
        HashMap map = ContainerUtil.newHashMap();
        for (AjPathEntries.Entry entry : entries) {
            ModuleManager manager;
            Module module;
            if (entry instanceof AjPathEntries.LibraryEntry) {
                LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
                LibraryTable table = entry instanceof AjPathEntries.AppLibraryEntry ? registrar.getLibraryTable() : registrar.getLibraryTable(project);
                Library library = table.getLibraryByName(entry.getName());
                if (!LibraryUtil.isJavaLibrary(library)) continue;
                map.put(entry, library);
                continue;
            }
            if (!(entry instanceof AjPathEntries.ModuleEntry) || !LibraryUtil.isJavaModule(module = (manager = ModuleManager.getInstance((Project)project)).findModuleByName(entry.getName()))) continue;
            map.put(entry, module);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/util/LibraryUtil", "mapEntries"));
        }
        return hashMap;
    }

    @NotNull
    public static List<Object> getAspectPathCandidates(@NotNull Module module, @NotNull Collection<Object> existing) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/aspectj/util/LibraryUtil", "getAspectPathCandidates"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/aspectj/util/LibraryUtil", "getAspectPathCandidates"));
        }
        ArrayList candidates = ContainerUtil.newArrayList();
        HashSet visited = ContainerUtil.newHashSet();
        LibraryUtil.collectCandidates(module, existing, candidates, false, visited);
        candidates.remove(module);
        ArrayList arrayList = candidates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/util/LibraryUtil", "getAspectPathCandidates"));
        }
        return arrayList;
    }

    private static void collectCandidates(Module module, final Collection<Object> filter, final List<Object> candidates, final boolean exportedOnly, final Set<Module> visited) {
        if (!visited.add(module)) {
            return;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().withoutSdk().compileOnly().forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry entry) {
                if (!exportedOnly || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).isExported()) {
                    Module dependency;
                    Module candidate = null;
                    if (entry instanceof LibraryOrderEntry && LIB_LEVELS.contains(((LibraryOrderEntry)entry).getLibraryLevel())) {
                        Library dependency2 = ((LibraryOrderEntry)entry).getLibrary();
                        if (LibraryUtil.isJavaLibrary(dependency2)) {
                            candidate = dependency2;
                        }
                    } else if (entry instanceof ModuleOrderEntry && LibraryUtil.isJavaModule(dependency = ((ModuleOrderEntry)entry).getModule())) {
                        candidate = dependency;
                        LibraryUtil.collectCandidates(dependency, filter, candidates, true, visited);
                    }
                    if (candidate != null && !filter.contains(candidate)) {
                        candidates.add(candidate);
                    }
                }
                return true;
            }
        });
    }

    private static boolean isJavaLibrary(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.CLASSES).length > 0;
    }

    private static boolean isJavaModule(@Nullable Module module) {
        return module != null && ModuleType.get((Module)module) instanceof JavaModuleType;
    }

    @NotNull
    public static AjPathEntries.Entry create(@NotNull Library library) {
        AjPathEntries.AppLibraryEntry entry;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/aspectj/util/LibraryUtil", "create"));
        }
        String level = library.getTable().getTableLevel();
        if ("application".equals(level)) {
            entry = new AjPathEntries.AppLibraryEntry();
        } else if ("project".equals(level)) {
            entry = new AjPathEntries.ProjectLibraryEntry();
        } else {
            throw new IllegalArgumentException("Unknown level: " + level + " (" + library + ")");
        }
        entry.setName(library.getName());
        AjPathEntries.AppLibraryEntry appLibraryEntry = entry;
        if (appLibraryEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/util/LibraryUtil", "create"));
        }
        return appLibraryEntry;
    }

    @NotNull
    public static AjPathEntries.Entry create(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/aspectj/util/LibraryUtil", "create"));
        }
        AjPathEntries.ModuleEntry entry = new AjPathEntries.ModuleEntry();
        entry.setName(module.getName());
        AjPathEntries.ModuleEntry moduleEntry = entry;
        if (moduleEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/util/LibraryUtil", "create"));
        }
        return moduleEntry;
    }
}

