/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.converters.CustomConverterRegistry;
import com.intellij.spring.model.converters.PropertyKeyConverter;
import com.intellij.spring.ws.converters.NamespaceReference;
import com.intellij.spring.ws.converters.PayloadRootReference;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndpointMappingKeyValueConverter
extends Converter<String>
implements CustomReferenceConverter,
CustomConverterRegistry.Provider {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String o, ConvertContext context) {
        return o;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String stringValue = genericDomValue.getStringValue();
        if (stringValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange textRange = this.getNamespaceTextRange(element);
        if (textRange != null) {
            TextRange payloadRootTextRange;
            HashSet refs = new HashSet();
            NamespaceReference namespaceReference = new NamespaceReference(element, textRange);
            refs.add(namespaceReference);
            PsiElement psiElement = namespaceReference.resolve();
            if (psiElement instanceof XmlFile && (payloadRootTextRange = this.getPayloadRootTextRange(element)) != null) {
                refs.add(new PayloadRootReference(element, payloadRootTextRange, (XmlFile)psiElement, namespaceReference.getValue()));
            }
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createSoftWebServiceAddressingreference(element, context.getModule())};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private PsiReference createSoftWebServiceAddressingreference(@NotNull PsiElement element, final @Nullable Module module) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "createSoftWebServiceAddressingreference"));
        }
        return new PsiReferenceBase<PsiElement>(element){

            public PsiElement resolve() {
                return this.getElement();
            }

            @NotNull
            public Object[] getVariants() {
                if (module != null) {
                    Set<String> set = SpringWebServicesUtil.collectWebServiceAddressingInputActions(module).keySet();
                    Object[] objectArray = ArrayUtil.toObjectArray(set);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter$1", "getVariants"));
                    }
                    return objectArray;
                }
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
        };
    }

    @Nullable
    private TextRange getNamespaceTextRange(@NotNull PsiElement element) {
        int end;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "getNamespaceTextRange"));
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        int start = text.indexOf("{");
        if (start >= 0 && (end = text.indexOf("}", start)) > 0) {
            return new TextRange(offset + start + 1, offset + end);
        }
        return null;
    }

    @Nullable
    private TextRange getPayloadRootTextRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/converters/EndpointMappingKeyValueConverter", "getPayloadRootTextRange"));
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        int start = text.indexOf("}");
        if (start >= 0) {
            return TextRange.from((int)(offset + start + 1), (int)(text.substring(start).length() - 1));
        }
        return null;
    }

    public Converter getConverter() {
        return this;
    }

    public Class getConverterClass() {
        return PropertyKeyConverter.class;
    }

    public boolean value(GenericDomValue genericDomValue) {
        return SpringWebServicesUtil.isEndpointMappingProperty(genericDomValue);
    }
}

