/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import org.jetbrains.annotations.NotNull;

public class CreateSpringWebServiceApplicationContextFix
implements LocalQuickFix {
    private String myServletName;
    private PsiDirectory myPsiDirectory;

    public CreateSpringWebServiceApplicationContextFix(@NotNull String servletName, @NotNull PsiDirectory psiDirectory) {
        if (servletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servletName", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "<init>"));
        }
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "<init>"));
        }
        this.myServletName = servletName;
        this.myPsiDirectory = psiDirectory;
    }

    @NotNull
    public String getName() {
        String string = SpringWebServicesBundle.message("CreateSpringWebServiceApplicationContextFix.display.name", SpringWebServicesUtil.getApplicationContextFileName(this.myServletName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringWebServicesBundle.message("CreateSpringWebServiceApplicationContextFix.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix", "applyFix"));
        }
        final String fileName = SpringWebServicesUtil.getApplicationContextFileName(this.myServletName);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix$1", "run"));
                }
                SpringCommonUtils.createSpringXmlConfigFile((String)fileName, (PsiDirectory)CreateSpringWebServiceApplicationContextFix.this.myPsiDirectory);
            }
        }.execute();
    }
}

