/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.configuration;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportProvider;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportTemplatesRunner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransportSupportFix
implements LocalQuickFix,
IntentionAction {
    private XmlFile myXmlFile;

    public AbstractTransportSupportFix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "<init>"));
        }
        this.myXmlFile = xmlFile;
    }

    protected abstract FrameworkSupportProvider getFrameworkSupportProvider();

    protected void doFix(Project project) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myXmlFile);
        Editor textEditor = FileEditorManager.getInstance((Project)this.myXmlFile.getProject()).getSelectedTextEditor();
        if (module != null && textEditor != null) {
            FrameworkSupportTemplatesRunner.getInstance().generateSpringBeans(this.getFrameworkSupportProvider(), module, textEditor, this.myXmlFile);
        }
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "invoke"));
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix", "applyFix"));
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }
}

