/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.JamSimpleReference;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.ws.jam.AbstractPayloadRootChildrenConverter;
import com.intellij.spring.ws.jam.SpringWebServicePayloadRoot;
import com.intellij.spring.ws.jam.SpringWebServiceXPathReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class SpringWebServiceXPathReferenceConverter
extends AbstractPayloadRootChildrenConverter {
    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
        SpringWebServicePayloadRoot payloadRoot = this.getPayLoadRoot(context);
        if (payloadRoot != null) {
            final PsiFile namespaceFile = payloadRoot.getNamespaceFile();
            final String namespace = payloadRoot.getNamespace();
            final String localPart = payloadRoot.getLocalPart();
            String xpath = (String)context.getValue();
            if (namespaceFile != null && !StringUtil.isEmptyOrSpaces((String)localPart) && !StringUtil.isEmptyOrSpaces((String)xpath)) {
                SpringWebServiceXPathReferenceSet set = new SpringWebServiceXPathReferenceSet(context.getPsiLiteral()){

                    @Override
                    public XmlFile getNamespaceFile() {
                        return (XmlFile)namespaceFile;
                    }

                    @Override
                    public String getNamespace() {
                        return namespace;
                    }

                    @Override
                    public String getLocalPart() {
                        return localPart;
                    }
                };
                PsiReference[] psiReferenceArray = set.getPsiReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceConverter", "createReferences"));
                }
                return psiReferenceArray;
            }
        }
        PsiReference[] psiReferenceArray = super.createReferences(context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public JamSimpleReference<String> createReference(final JamStringAttributeElement<String> context) {
        JamSimpleReference<String> jamSimpleReference = new JamSimpleReference<String>(context){

            public PsiElement resolve() {
                String s = this.getValue();
                if (StringUtil.isEmptyOrSpaces((String)s)) {
                    return null;
                }
                for (XmlTag xmlTag : SpringWebServiceXPathReferenceConverter.this.getElementTags((JamStringAttributeElement<String>)context)) {
                    XmlAttribute attribute = xmlTag.getAttribute("name");
                    if (attribute == null || !s.equals(attribute.getValue())) continue;
                    return attribute.getValueElement();
                }
                return super.resolve();
            }
        };
        if (jamSimpleReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/SpringWebServiceXPathReferenceConverter", "createReference"));
        }
        return jamSimpleReference;
    }

    public LookupElement[] getLookupVariants(JamStringAttributeElement<String> context) {
        return (LookupElement[])ContainerUtil.map2Array((Object[])this.getElementTags(context), LookupElement.class, (Function)new Function<XmlTag, LookupElement>(){

            public LookupElement fun(XmlTag xmlTag) {
                return LookupElementBuilder.create((String)xmlTag.getAttributeValue("name"));
            }
        });
    }

    private XmlTag[] getElementTags(JamStringAttributeElement<String> context) {
        PsiFile file;
        SpringWebServicePayloadRoot payloadRoot;
        PsiAnnotation psiAnnotation = (PsiAnnotation)context.getParentAnnotationElement().getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMethod.class);
        if (method != null && (payloadRoot = (SpringWebServicePayloadRoot)SpringWebServicePayloadRoot.METHOD_META.getJamElement((PsiModifierListOwner)method)) != null && (file = payloadRoot.getNamespaceFile()) instanceof XmlFile) {
            XmlTag rootTag = ((XmlFile)file).getDocument().getRootTag();
            return rootTag.findSubTags("element", rootTag.getNamespace());
        }
        return XmlTag.EMPTY;
    }
}

