/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.actions;

import com.intellij.batch.resources.BatchBundle;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import icons.BatchCoreIcons;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateBatchJobFileAction
extends CreateFileAction {
    public CreateBatchJobFileAction() {
        super(BatchBundle.message("batch.job.new.file", new Object[0]), BatchBundle.message("create.new.batch.job.file", new Object[0]), BatchCoreIcons.Batch);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module != null && BatchCommonUtils.isBatchInstalled(module) && CreateBatchJobFileAction.isDirectoryAccepted(module, dataContext);
    }

    private static boolean isDirectoryAccepted(Module module, DataContext context) {
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(context);
        if (view != null) {
            for (PsiDirectory dir : view.getDirectories()) {
                if (!dir.getName().equals("batch-jobs")) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/actions/CreateBatchJobFileAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        String fileName = FileUtilRt.getExtension((String)newName).length() == 0 ? newName + ".xml" : newName;
        Properties properties = new Properties();
        properties.setProperty("JOB_ID", newName);
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)CreateBatchJobFileAction.getTemplate(directory.getProject()), (String)fileName, (Properties)properties, (PsiDirectory)directory);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/actions/CreateBatchJobFileAction", "create"));
        }
        return psiElementArray;
    }

    @NotNull
    protected static FileTemplate getTemplate(Project project) {
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("job.xml");
        if (fileTemplate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/actions/CreateBatchJobFileAction", "getTemplate"));
        }
        return fileTemplate;
    }
}

