/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.search.MethodSuperSearcher;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.aop.AopConfig;
import com.intellij.spring.model.xml.aop.AspectjAutoproxy;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.tx.AnnotationDriven;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAdvisedElementsSearcher
extends AopAdvisedElementsSearcher {
    private final AtomicNotNullLazyValue<Boolean> myCglibProxyType;
    private final CommonSpringModel myModel;

    public SpringAdvisedElementsSearcher(@NotNull PsiManager manager, CommonSpringModel model) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "<init>"));
        }
        super(manager);
        this.myCglibProxyType = new AtomicNotNullLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                for (XmlSpringModel xmlModel : SpringAdvisedElementsSearcher.findXmlModels(SpringAdvisedElementsSearcher.this.myModel)) {
                    for (LocalXmlModel localXmlModel : xmlModel.getLocalSpringModels()) {
                        DomFileElement root = localXmlModel.getRoot();
                        if (root == null || !SpringAdvisedElementsSearcher.isCglib((DomFileElement<Beans>)root)) continue;
                        Boolean bl = true;
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$1", "compute"));
                        }
                        return bl;
                    }
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$1", "compute"));
                }
                return bl;
            }
        };
        this.myModel = model;
    }

    private static boolean isCglib(final DomFileElement<Beans> root) {
        return (Boolean)CachedValuesManager.getManager((Project)root.getManager().getProject()).getCachedValue(root, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)SpringAdvisedElementsSearcher.calcIsCglib((DomFileElement<Beans>)root), (Object[])new Object[]{root});
            }
        });
    }

    private static boolean calcIsCglib(DomFileElement<Beans> domFileElement) {
        boolean hasAopNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key");
        boolean hasTxNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring TX namespace key");
        if (!hasAopNamespace && !hasTxNamespace) {
            return false;
        }
        DomElement rootElement = domFileElement.getRootElement();
        if (hasAopNamespace && SpringDomUtils.hasElement(domFileElement, AopConfig.class)) {
            for (AopConfig config : DomUtil.getDefinedChildrenOfType((DomElement)rootElement, AopConfig.class, (boolean)true, (boolean)false)) {
                if (!Boolean.TRUE.equals(config.getProxyTargetClass().getValue())) continue;
                return true;
            }
        }
        if (!SpringDomUtils.hasElement(domFileElement, AnnotationDriven.class) && !SpringDomUtils.hasElement(domFileElement, AspectjAutoproxy.class)) {
            return false;
        }
        CommonProcessors.FindFirstProcessor<CommonSpringBean> processor = new CommonProcessors.FindFirstProcessor<CommonSpringBean>(){

            protected boolean accept(CommonSpringBean bean) {
                return bean instanceof AnnotationDriven && Boolean.TRUE.equals(((AnnotationDriven)bean).getProxyTargetClass().getValue()) || bean instanceof AspectjAutoproxy && Boolean.TRUE.equals(((AspectjAutoproxy)bean).getProxyTargetClass().getValue());
            }
        };
        SpringBeanUtils.getInstance().processChildBeans(rootElement, false, (Processor)processor);
        return processor.isFound();
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isInherentlyAdvisable"));
        }
        return SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass);
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isAdvisableInModel"));
        }
        return this.isSpringBeanClass(psiClass);
    }

    private boolean isSpringBeanClass(final PsiClass psiClass) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                boolean found = SpringModelSearchers.doesBeanExist((CommonSpringModel)SpringAdvisedElementsSearcher.this.myModel, (PsiClass)psiClass);
                ArrayList dependencies = new ArrayList(5);
                dependencies.addAll(ContainerUtil.newArrayList((Object[])SpringModificationTrackersManager.getInstance((Project)psiClass.getProject()).getOuterModelsDependencies()));
                dependencies.addAll(SpringAdvisedElementsSearcher.this.myModel.getConfigFiles());
                return CachedValueProvider.Result.create((Object)found, (Object[])ArrayUtil.toObjectArray(dependencies));
            }
        });
    }

    private static boolean isSpringAopAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isSpringAopAdvisable"));
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("final")) {
            return false;
        }
        if (SpringAdvisedElementsSearcher.isSpringAopClass(psiClass)) {
            return false;
        }
        return SpringAdvisedElementsSearcher.isAspectjAdvisable((PsiClass)psiClass);
    }

    public LinkedHashSet<PsiClass> collectAdvisedClasses() {
        final MyBeanVisitor visitor = new MyBeanVisitor();
        Collection beans = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<? extends SpringBeanPointer>>(){

            public Collection<? extends SpringBeanPointer> compute() {
                return SpringAdvisedElementsSearcher.this.myModel.getAllCommonBeans();
            }
        });
        for (final SpringBeanPointer pointer : beans) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (!pointer.isValid()) {
                        return;
                    }
                    if (pointer instanceof DomSpringBeanPointer) {
                        SpringModelVisitor.visitBean((SpringModelVisitor)visitor, (CommonSpringBean)((DomSpringBeanPointer)pointer).getSpringBean());
                    } else {
                        visitor.processBeanClass(pointer.getEffectiveBeanType());
                    }
                }
            });
        }
        return visitor.result;
    }

    public static List<XmlSpringModel> findXmlModels(CommonSpringModel model) {
        if (model instanceof XmlSpringModel) {
            return Collections.singletonList((XmlSpringModel)model);
        }
        if (model instanceof CombinedSpringModel) {
            return ContainerUtil.findAll((Collection)((CombinedSpringModel)model).getUnderlyingModels(), XmlSpringModel.class);
        }
        return Collections.emptyList();
    }

    private static boolean isSpringAopClass(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isSpringAopClass"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            public CachedValueProvider.Result<Boolean> compute() {
                boolean result = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, (Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        String qname = psiClass.getQualifiedName();
                        return !"org.springframework.aop.Advisor".equals(qname) && !"org.aopalliance.aop.Advice".equals(qname) && !"org.springframework.aop.framework.AopInfrastructureBean".equals(qname);
                    }
                });
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    private static boolean hasInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "hasInterfaces"));
        }
        return !JamCommonUtil.processSuperClassList((PsiClass)psiClass, (Collection)new THashSet(), (Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass psiClass) {
                return psiClass.getInterfaces().length == 0;
            }
        });
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "canBeAdvised"));
        }
        if (!super.canBeAdvised(method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("final")) {
            return false;
        }
        return !method.hasModifierProperty("private");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "acceptsBoundMethodHeavy"));
        }
        if (this.isJdkProxyType() && ((psiClass = method.getContainingClass()) == null || SpringAdvisedElementsSearcher.hasInterfaces(psiClass) && !SpringAdvisedElementsSearcher.isFromInterface(method, psiClass))) {
            return false;
        }
        return super.acceptsBoundMethodHeavy(method);
    }

    public boolean isJdkProxyType() {
        return (Boolean)this.myCglibProxyType.getValue() == false;
    }

    private static boolean isFromInterface(@NotNull PsiMethod method, PsiClass psiClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isFromInterface"));
        }
        return !new MethodSuperSearcher().execute(new SuperMethodsSearch.SearchParameters(method, psiClass, true, false), (Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

            public boolean process(MethodSignatureBackedByPsiMethod signature) {
                PsiClass aClass = signature.getMethod().getContainingClass();
                return aClass == null || !aClass.isInterface();
            }
        });
    }

    public CommonSpringModel getSpringModel() {
        return this.myModel;
    }

    private static class MyBeanVisitor
    extends SpringModelVisitor {
        private final LinkedHashSet<PsiClass> result = ContainerUtilRt.newLinkedHashSet();

        private MyBeanVisitor() {
        }

        protected boolean visitBean(CommonSpringBean bean) {
            ProgressManager.checkCanceled();
            this.processBeanClass(BeanService.getInstance().getEffectiveBeanTypes(bean));
            super.visitBean(bean);
            return true;
        }

        final void processBeanClass(@NotNull PsiClass[] effectiveTypes) {
            if (effectiveTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveTypes", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$MyBeanVisitor", "processBeanClass"));
            }
            for (PsiClass beanClass : effectiveTypes) {
                if (!SpringAdvisedElementsSearcher.isSpringAopAdvisable(beanClass)) continue;
                this.result.add(beanClass);
                this.addAdvisableSupers(beanClass);
            }
        }

        private void addAdvisableSupers(PsiClass beanClass) {
            InheritanceUtil.processSupers((PsiClass)beanClass, (boolean)false, (Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    if (SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) {
                        MyBeanVisitor.this.result.add(psiClass);
                    }
                    return true;
                }
            });
        }
    }
}

