/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopIntroduction;
import com.intellij.aop.jam.AopJavaAnnotator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringAopEffectiveTypesProvider
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, final Collection<PsiClass> result) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/aop/SpringAopEffectiveTypesProvider", "processEffectiveTypes"));
        }
        Set toAdd = (Set)RecursionManager.doPreventingRecursion((Object)bean, (boolean)true, (Computable)new Computable<Set<PsiClass>>(){

            public Set<PsiClass> compute() {
                THashSet toAdd = new THashSet();
                for (PsiClass psiClass : result) {
                    for (AopIntroduction introduction : AopJavaAnnotator.getBoundIntroductionsForModelClass((PsiClass)psiClass)) {
                        PsiClass value = (PsiClass)introduction.getImplementInterface().getValue();
                        if (value == null || !value.isValid()) continue;
                        toAdd.add(value);
                    }
                }
                return toAdd;
            }
        });
        if (toAdd != null) {
            result.addAll(toAdd);
        }
    }
}

