/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.version;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.resin.version.GenericResinVersion;
import org.intellij.j2ee.web.resin.resin.version.JarClassLoader;
import org.intellij.j2ee.web.resin.resin.version.ResinVersion;
import org.intellij.j2ee.web.resin.resin.version.StartupClassFinder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class ClassCallDetector {
    private static final Logger LOG = Logger.getInstance((String)("#" + ClassCallDetector.class.getName()));
    @NonNls
    private static final String RESIN_VERSION_CLASS = "com.caucho.Version";
    @NonNls
    private static final String RESIN_XDEBUG_CLASS = "com.caucho.log.LogManagerImpl";
    @NonNls
    private static final String RESIN_JMX_CLASS = "com.caucho.jmx.MBeanServerBuilderImpl";
    @NonNls
    private static final String RESIN_VERSION_CLASS_ATT_NAME = "VERSION";

    private ClassCallDetector() {
    }

    @Nullable
    public static ResinVersion getResinVersion(File resinHome) {
        try {
            File resinJar = new File(resinHome, FileUtil.toSystemDependentName((String)"lib/resin.jar"));
            if (!resinJar.exists()) {
                return null;
            }
            JarClassLoader loader = new JarClassLoader(resinJar.getAbsolutePath());
            String version = ClassCallDetector.getResinVersionFromClass(loader);
            if (version == null) {
                version = ClassCallDetector.getResinVersionFromManifest(resinJar);
            }
            String startupClass = StartupClassFinder.getStartupClassForVersion(version);
            boolean allowDebug = ClassCallDetector.hasClass(loader, RESIN_XDEBUG_CLASS);
            boolean allowJmx = ClassCallDetector.hasClass(loader, RESIN_JMX_CLASS);
            return startupClass == null ? null : new GenericResinVersion(ResinBundle.message("resin.version.prefix", version), version, startupClass, allowDebug, allowJmx);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String getResinVersionFromClass(JarClassLoader loader) {
        try {
            Class versionClass = loader.loadClass(RESIN_VERSION_CLASS);
            Field field = versionClass.getDeclaredField(RESIN_VERSION_CLASS_ATT_NAME);
            return field.get(null).toString();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResinVersionFromManifest(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        try {
            Attributes attributes = jar.getManifest().getMainAttributes();
            if (attributes == null) {
                String string = null;
                return string;
            }
            String string = attributes.getValue("Implementation-Version");
            return string;
        }
        finally {
            jar.close();
        }
    }

    private static boolean hasClass(JarClassLoader loader, @NonNls String className) {
        try {
            return loader.loadClass(className) != null;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

