/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdviceType;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.jam.AopAdviceMetas;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.aop.jam.PointcutContainer;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.jam.JamChief;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AopAdviceImpl
implements JamChief,
AopAdvice,
PointcutContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.AopAdviceImpl");
    private final AopAdviceType myType;
    protected final JamAnnotationMeta myAnnoMeta;

    public AopAdviceImpl(AopAdviceType type, JamAnnotationMeta annoMeta) {
        this.myAnnoMeta = annoMeta;
        this.myType = type;
    }

    @Nullable
    protected PsiAnnotationMemberValue getAnnoParam() {
        return ((JamStringAttributeElement)this.myAnnoMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), AopAdviceMetas.VALUE_ATTR)).getPsiElement();
    }

    @Override
    public JamStringAttributeElement<String> getArgNames() {
        return (JamStringAttributeElement)this.myAnnoMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), AopAdviceMetas.ARG_NAMES_ATTR);
    }

    @Override
    @Nullable
    public PsiPointcutExpression getPointcutExpression() {
        PsiAnnotationMemberValue param = this.getAnnoParam();
        return AopPointcutImpl.getPsiPointcutExpression((PsiElement)param);
    }

    @Override
    @NotNull
    public AopAdviceType getAdviceType() {
        AopAdviceType aopAdviceType = this.myType;
        if (aopAdviceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopAdviceImpl", "getAdviceType"));
        }
        return aopAdviceType;
    }

    @Override
    public AopAdvisedElementsSearcher getSearcher() {
        PsiPointcutExpression expression = this.getPointcutExpression();
        return expression == null ? null : AopPointcutUtil.getHolder(expression).getAopModel().getAdvisedElementsSearcher();
    }

    @Override
    public PointcutMatchDegree accepts(PsiMethod method) {
        PsiPointcutExpression expression = this.getPointcutExpression();
        if (expression == null) {
            return PointcutMatchDegree.FALSE;
        }
        if (!expression.isValid()) {
            LOG.error("Invalid pointcut expression: " + method.getModifierList().getText());
            return PointcutMatchDegree.FALSE;
        }
        return expression.acceptsSubject(new PointcutContext(expression), (PsiMember)method);
    }

    public XmlTag getXmlTag() {
        return null;
    }

    public Module getModule() {
        return null;
    }

    public PsiAnnotation getIdentifyingPsiElement() {
        return this.myAnnoMeta.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    public PsiFile getContainingFile() {
        return this.getPsiElement().getContainingFile();
    }

    @Nullable
    public static PsiParameter findParameter(@Nullable PsiMethod method, @NotNull String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/intellij/aop/jam/AopAdviceImpl", "findParameter"));
        }
        if (method != null) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                if (!parameterName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return this.getIdentifyingPsiElement();
    }

    public PsiManager getPsiManager() {
        return this.getPsiElement().getManager();
    }

    @JamPsiValidity
    public abstract boolean isValid();

    @JamPsiConnector
    public abstract PsiMethod getPsiElement();

    public static abstract class Around
    extends AopAdviceImpl {
        public Around() {
            super(AopAdviceType.AROUND, AopAdviceMetas.AROUND_META);
        }
    }

    public static abstract class After
    extends AopAdviceImpl {
        public After() {
            super(AopAdviceType.AFTER, AopAdviceMetas.AFTER_META);
        }
    }

    public static abstract class Before
    extends AopAdviceImpl {
        public Before() {
            super(AopAdviceType.BEFORE, AopAdviceMetas.BEFORE_META);
        }
    }
}

