/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopPointcut;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopMemberReferenceExpression;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopParenthesizedExpression;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionFileType;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceQualifier;
import com.intellij.aop.psi.ConcatenationPattern;
import com.intellij.aop.psi.PsiAtPointcutDesignator;
import com.intellij.aop.psi.PsiClassTypePattern;
import com.intellij.aop.psi.PsiExecutionExpression;
import com.intellij.aop.psi.PsiPointcutReferenceExpression;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractQualifiedReference;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import icons.AopCommonIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopReferenceExpression
extends AbstractQualifiedReference<AopReferenceExpression>
implements AopReferenceQualifier {
    public AopReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopReferenceExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopReferenceExpression";
    }

    @Nullable
    public AopReferenceQualifier getGeneralizedQualifier() {
        return (AopReferenceQualifier)this.findChildByClass(AopReferenceQualifier.class);
    }

    @Override
    @NotNull
    public Resolvability getResolvability() {
        if (this.isDoubleDot()) {
            Resolvability resolvability = Resolvability.NONE;
            if (resolvability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getResolvability"));
            }
            return resolvability;
        }
        AopReferenceQualifier qualifier = this.getGeneralizedQualifier();
        if (qualifier != null && qualifier.getResolvability() != Resolvability.PLAIN) {
            Resolvability resolvability = Resolvability.NONE;
            if (resolvability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getResolvability"));
            }
            return resolvability;
        }
        Resolvability resolvability = this.findChildByType(AopElementTypes.AOP_ASTERISK) != null ? (qualifier == null ? Resolvability.NONE : Resolvability.POLYVARIANT) : Resolvability.PLAIN;
        if (resolvability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getResolvability"));
        }
        return resolvability;
    }

    public final boolean isDoubleDot() {
        return this.findChildByType(AopElementTypes.AOP_DOT_DOT) != null;
    }

    private boolean isAcceptableTarget(PsiElement element) {
        if (element instanceof PsiParameter) {
            return true;
        }
        AopMemberReferenceExpression methodRef = (AopMemberReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)this, AopMemberReferenceExpression.class);
        if (methodRef == null && !this.isPointcutReference() && element instanceof PsiMethod) {
            return false;
        }
        return element instanceof PsiNamedElement && !(element instanceof PsiField);
    }

    @NotNull
    public AbstractQualifiedReference shortenReferences() {
        AopReferenceExpression aopReferenceExpression = this;
        if (aopReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "shortenReferences"));
        }
        return aopReferenceExpression;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/aop/psi/AopReferenceExpression", "bindToElement"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        return element instanceof PsiClass ? this.replaceReference(((PsiClass)element).getQualifiedName()) : super.bindToElement(element);
    }

    protected ResolveResult[] resolveInner() {
        final Pattern regex = this.getRegex();
        AbstractQualifiedReference.AbstractQualifiedReferenceResolvingProcessor processor = new AbstractQualifiedReference.AbstractQualifiedReferenceResolvingProcessor(){

            protected final void process(PsiElement element) {
                String name;
                if (AopReferenceExpression.this.isAcceptableTarget(element) && (name = ((PsiNamedElement)element).getName()) != null && regex.matcher(name).matches() && AopReferenceExpression.this.isAccessible(element)) {
                    if (element instanceof PsiMethod) {
                        if (AopReferenceExpression.this.getParent() instanceof AopReferenceQualifier) {
                            return;
                        }
                        AopPointcutImpl pointcut = JamAopModel.getPointcut((PsiMethod)element);
                        if (pointcut != null) {
                            this.addResult((ResolveResult)new AopPointcutResolveResult(pointcut));
                            return;
                        }
                    }
                    this.addResult((ResolveResult)new PsiElementResolveResult(element));
                }
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor);
        Set results = processor.getResults();
        HashSet<ResolveResult> pointcuts = new HashSet<ResolveResult>();
        for (ResolveResult result : results) {
            if (!(result instanceof AopPointcutResolveResult)) continue;
            pointcuts.add(result);
        }
        if (!pointcuts.isEmpty()) {
            return pointcuts.toArray(new ResolveResult[pointcuts.size()]);
        }
        return results.toArray(new ResolveResult[results.size()]);
    }

    @Nullable
    public AopPointcut resolvePointcut() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 && results[0] instanceof AopPointcutResolveResult ? ((AopPointcutResolveResult)results[0]).getPointcut() : null;
    }

    protected boolean processVariantsInner(PsiScopeProcessor processor) {
        return this.getResolvability() == Resolvability.NONE || super.processVariantsInner(processor);
    }

    protected boolean processUnqualifiedVariants(PsiScopeProcessor processor) {
        ResolveState state = ResolveState.initial();
        if (!AopPointcutUtil.getHolder(this).processDeclarations(processor, state, null, this)) {
            return false;
        }
        for (PsiParameter parameter : AopPointcutUtil.getHolder(this).getAopModel().resolveParameters(this.getOwnText())) {
            if (processor.execute((PsiElement)parameter, state)) continue;
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)this, PsiClass.class, (boolean)true);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        while (psiClass != null) {
            PsiPackage psiPackage;
            String fqName;
            if (!psiClass.processDeclarations(processor, state, null, (PsiElement)this)) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
            if (parentClass == null && (fqName = psiClass.getQualifiedName()) != null && (psiPackage = facade.findPackage(StringUtil.getPackageName((String)fqName))) != null && !psiPackage.processDeclarations(processor, state, null, (PsiElement)this)) {
                return false;
            }
            psiClass = parentClass;
        }
        PsiPackage psiPackage = facade.findPackage("java.lang");
        if (psiPackage != null && !psiPackage.processDeclarations((PsiScopeProcessor)new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiClass.class), processor), state, null, (PsiElement)this)) {
            return false;
        }
        psiPackage = facade.findPackage("");
        return psiPackage == null || psiPackage.processDeclarations(processor, state, null, (PsiElement)this);
    }

    protected PsiElement getReferenceNameElement() {
        return this.findChildByType(AopElementTypes.AOP_IDENTIFIER);
    }

    @NotNull
    protected final AopReferenceExpression parseReference(String newText) {
        String fileText = "execution((" + newText + ") *())";
        AopPointcutExpressionFile file = (AopPointcutExpressionFile)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a", (FileType)AopPointcutExpressionFileType.INSTANCE, (CharSequence)fileText);
        PsiExecutionExpression pointcutExpression = (PsiExecutionExpression)file.getPointcutExpression();
        assert (pointcutExpression != null);
        AopReferenceHolder returnType = pointcutExpression.getReturnType();
        assert (returnType != null);
        AopParenthesizedExpression typeExpression = (AopParenthesizedExpression)returnType.getTypeExpression();
        assert (typeExpression != null);
        AopReferenceExpression aopReferenceExpression = (AopReferenceExpression)ObjectUtils.assertNotNull((Object)typeExpression.getInnerTypeExpression());
        if (aopReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "parseReference"));
        }
        return aopReferenceExpression;
    }

    @Nullable
    protected PsiElement getSeparator() {
        return this.findChildByType(AopElementTypes.AOP_DOTS);
    }

    protected boolean isAccessible(PsiElement element) {
        if (element instanceof PsiMethod && !((PsiMethod)element).hasModifierProperty("public") && this.getContainingFile().getContext() instanceof XmlElement) {
            return false;
        }
        return super.isAccessible(element);
    }

    @NotNull
    public LookupElement[] getVariants() {
        THashSet signatures = ContainerUtil.newTroveSet();
        final ArrayList<LookupElementBuilder> list = new ArrayList<LookupElementBuilder>();
        if (this.isPointcutReference()) {
            LocalAopModel model = AopPointcutUtil.getHolder(this).getAopModel();
            final PsiMethod pointcutMethod = model.getPointcutMethod();
            THashSet qNames = new THashSet();
            final String prefix = this.getText().substring(0, this.getRangeInElement().getStartOffset());
            this.processVariantsInner((PsiScopeProcessor)new BaseScopeProcessor((Set)qNames){
                final /* synthetic */ Set val$qNames;
                {
                    this.val$qNames = set;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    PsiMethod method;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/aop/psi/AopReferenceExpression$2", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/aop/psi/AopReferenceExpression$2", "execute"));
                    }
                    if (element instanceof PsiMethod && element != pointcutMethod && CompletionUtil.getOriginalOrSelf((PsiElement)element) != pointcutMethod && AopReferenceExpression.this.isAccessible(element) && (method = (PsiMethod)element).getModifierList().findAnnotation("org.aspectj.lang.annotation.Pointcut") != null) {
                        PsiFile file;
                        String methodName = method.getName();
                        list.add(LookupElementBuilder.create((String)(prefix + methodName)).withIcon(AopCommonIcons.Pointcut).withInsertHandler((InsertHandler)new MethodParenthesesHandler(method, true)));
                        PsiClass aClass = method.getContainingClass();
                        if (aClass != null && !(aClass instanceof PsiAnonymousClass) && (file = aClass.getContainingFile().getOriginalFile()) instanceof PsiJavaFile) {
                            PsiJavaFile javaFile = (PsiJavaFile)file;
                            String packageName = javaFile.getPackageName();
                            String prefix2 = StringUtil.isEmpty((String)packageName) ? "" : packageName + ".";
                            this.val$qNames.add(prefix2 + aClass.getName() + "." + methodName);
                        }
                    }
                    return true;
                }
            });
            for (AopPointcut aopPointcut : model.getPointcuts()) {
                String qname;
                PsiElement element = aopPointcut.getIdentifyingPsiElement();
                if (!(element instanceof PsiAnnotation)) continue;
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                assert (method != null);
                if (method == pointcutMethod || CompletionUtil.getOriginalOrSelf((PsiElement)method) == pointcutMethod || !this.isAccessible((PsiElement)method) || (qname = aopPointcut.getQualifiedName().getStringValue()) == null || !qname.startsWith(prefix) || qNames.contains(qname)) continue;
                list.add(LookupElementBuilder.create((String)qname).withIcon(AopCommonIcons.Pointcut).withInsertHandler((InsertHandler)new MethodParenthesesHandler(method, false)));
            }
        } else {
            this.processVariantsInner((PsiScopeProcessor)new BaseScopeProcessor((Set)signatures, list){
                final /* synthetic */ Set val$signatures;
                final /* synthetic */ List val$list;
                {
                    this.val$signatures = set;
                    this.val$list = list;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/aop/psi/AopReferenceExpression$3", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/aop/psi/AopReferenceExpression$3", "execute"));
                    }
                    if (AopReferenceExpression.this.isAcceptableTarget(element)) {
                        PsiNamedElement namedElement = (PsiNamedElement)element;
                        String name = namedElement.getName();
                        assert (name != null);
                        LookupElementBuilder item = LookupElementBuilder.create((Object)namedElement, (String)name);
                        if (element instanceof PsiMethod) {
                            if (!this.val$signatures.add(((PsiMethod)element).getSignature((PsiSubstitutor)state.get(PsiSubstitutor.KEY)))) {
                                return true;
                            }
                            item = item.withInsertHandler((InsertHandler)new MethodParenthesesHandler((PsiMethod)element, true));
                        }
                        if (element instanceof PsiPackage) {
                            this.val$list.add(TailTypeDecorator.withTail((LookupElement)item, (TailType)TailType.DOT));
                        } else {
                            this.val$list.add(item);
                        }
                    }
                    return true;
                }
            });
        }
        LookupElement[] lookupElementArray = list.toArray(new LookupElement[list.size()]);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getVariants"));
        }
        return lookupElementArray;
    }

    public final boolean isPointcutReference() {
        return this.getParent() instanceof PsiPointcutReferenceExpression;
    }

    public final boolean isAnnotationReference() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof AopReferenceHolder)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof AopParameterList ? grandParent.getParent() instanceof PsiAtPointcutDesignator : grandParent instanceof PsiAtPointcutDesignator;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        String qualifiedName;
        String text = this.getText().trim();
        if ("*".equals(text)) {
            List<AopPsiTypePattern> list = Arrays.asList(AopPsiTypePattern.TRUE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
            }
            return list;
        }
        AopReferenceQualifier qualifier = this.getGeneralizedQualifier();
        if (qualifier != null) {
            AopPsiTypePattern pattern;
            String prefix;
            Collection<AopPsiTypePattern> patterns = qualifier.getPatterns();
            if (patterns.isEmpty()) {
                Collection<AopPsiTypePattern> collection = patterns;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
                }
                return collection;
            }
            final boolean doubleDot = this.isDoubleDot();
            String ownText = this.getOwnText();
            if (patterns.size() == 1 && (prefix = (pattern = patterns.iterator().next()) instanceof PsiClassTypePattern ? ((PsiClassTypePattern)pattern).getText() : (pattern == AopPsiTypePattern.TRUE ? "*" : null)) != null) {
                List<AopPsiTypePattern> list = Arrays.asList(new PsiClassTypePattern(prefix + (doubleDot ? ".." : ".") + ownText));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
                }
                return list;
            }
            final AopPsiTypePattern rightPattern = "*".equals(ownText) ? AopPsiTypePattern.TRUE : new PsiClassTypePattern(ownText);
            List list = ContainerUtil.map2List(patterns, (Function)new Function<AopPsiTypePattern, AopPsiTypePattern>(){

                public AopPsiTypePattern fun(AopPsiTypePattern aopPsiTypePattern) {
                    return new ConcatenationPattern(aopPsiTypePattern, rightPattern, doubleDot);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
            }
            return list;
        }
        PsiElement psiElement = this.resolve();
        if (psiElement instanceof PsiClass && (qualifiedName = ((PsiClass)psiElement).getQualifiedName()) != null) {
            List<AopPsiTypePattern> list = Arrays.asList(new PsiClassTypePattern(qualifiedName));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
            }
            return list;
        }
        List<AopPsiTypePattern> list = Arrays.asList(new PsiClassTypePattern(text));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression", "getPatterns"));
        }
        return list;
    }

    @Override
    public String getTypePattern() {
        String qualifiedName;
        PsiElement psiElement;
        if (this.getGeneralizedQualifier() == null && (psiElement = this.resolve()) instanceof PsiClass && (qualifiedName = ((PsiClass)psiElement).getQualifiedName()) != null) {
            return "'_:[regex(" + qualifiedName.replaceAll("\\.", "\\\\.") + ")]";
        }
        String text = this.getText().replaceAll(" ", "");
        String regex = "*".equals(text) ? ".*" : text.replaceAll("\\*", "\\[\\^\\\\.]\\+").replaceAll("\\.", "\\\\.").replaceAll("\\\\.\\\\.", "\\\\..*\\\\.");
        return "'_:[regex(" + regex + ")]";
    }

    public Pattern getRegex() {
        return Pattern.compile(this.getOwnText().replaceAll("\\*", ".*"));
    }

    private String getOwnText() {
        return this.getRangeInElement().substring(this.getText());
    }

    private static class AopPointcutResolveResult
    extends PsiElementResolveResult {
        @NotNull
        private final AopPointcut myPointcut;

        public AopPointcutResolveResult(@NotNull AopPointcutImpl pointcut) {
            if (pointcut == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointcut", "com/intellij/aop/psi/AopReferenceExpression$AopPointcutResolveResult", "<init>"));
            }
            super((PsiElement)ObjectUtils.assertNotNull((Object)pointcut.getPsiElement()));
            this.myPointcut = pointcut;
        }

        @NotNull
        public AopPointcut getPointcut() {
            AopPointcut aopPointcut = this.myPointcut;
            if (aopPointcut == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceExpression$AopPointcutResolveResult", "getPointcut"));
            }
            return aopPointcut;
        }
    }

    static enum Resolvability {
        PLAIN,
        POLYVARIANT,
        NONE;

    }
}

