/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.highlighter;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import icons.HamlIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.highlighter.HAMLHighlighter;
import org.jetbrains.plugins.haml.highlighter.HAMLSyntaxHighlighter;

public class HAMLColorsPage
implements ColorSettingsPage {
    private static final String DEMO_TEXT = "!!! XML\n%html{ :xmlns => \"http://www.w3.org/1999/xhtml\", :lang => \"en\", 'xml:lang' => \"en\" }\n  %head\n    %title BoBlog\n  %body\n    #header\n      %h1 Best |\n     Blog ever |\n\n    /Some comment here\n    #content\n      - @entries.each do |entry|\n        .entry\n          %h3.title= entry.title\n          %p.body= entry.body\n    :textile\n      h1. Hello World\n    %br/\n    %blockquote>\n      %div\n        Foo!\n    %img(<attr>src=</attr>\"foo.png\" <attr>width=</attr>'200' <attr>height=</attr>'100')><\n    %p Copyright *Bob*";
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(HamlBundle.message("color.settings.haml.tag"), HAMLHighlighter.TAG), new AttributesDescriptor(HamlBundle.message("color.settings.haml.tag.name"), HAMLHighlighter.TAG_NAME), new AttributesDescriptor(HamlBundle.message("color.settings.haml.tag.attr.key"), HAMLHighlighter.TAG_ATTR_KEY), new AttributesDescriptor(HamlBundle.message("color.settings.haml.class"), HAMLHighlighter.CLASS), new AttributesDescriptor(HamlBundle.message("color.settings.haml.id"), HAMLHighlighter.ID), new AttributesDescriptor(HamlBundle.message("color.settings.haml.comment"), HAMLHighlighter.COMMENT), new AttributesDescriptor(HamlBundle.message("color.settings.haml.xhtml"), HAMLHighlighter.XHTML), new AttributesDescriptor(HamlBundle.message("color.settings.haml.injected.code"), HAMLHighlighter.INJECTED_CODE), new AttributesDescriptor(HamlBundle.message("color.settings.haml.evaluator"), HAMLHighlighter.RUBY_START), new AttributesDescriptor(HamlBundle.message("color.settings.haml.text"), HAMLHighlighter.TEXT), new AttributesDescriptor(HamlBundle.message("color.settings.haml.line.continuation"), HAMLHighlighter.LINE_CONTINUATION), new AttributesDescriptor(HamlBundle.message("color.settings.haml.parenthesis"), HAMLHighlighter.PARENTHS), new AttributesDescriptor(HamlBundle.message("color.settings.haml.spaces.eater"), HAMLHighlighter.SPACES_EATER), new AttributesDescriptor(HamlBundle.message("color.settings.haml.filter"), HAMLHighlighter.FILTER), new AttributesDescriptor(HamlBundle.message("color.settings.haml.filter.content"), HAMLHighlighter.FILTER_CONTENT), new AttributesDescriptor(HamlBundle.message("color.settings.haml.string"), HAMLHighlighter.STRING), new AttributesDescriptor(HamlBundle.message("color.settings.haml.string.interpolated"), HAMLHighlighter.STRING_INTERPOLATED)};
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();
    private static final ColorDescriptor[] COLORS;

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    @NotNull
    public String getDisplayName() {
        String string = HamlBundle.message("color.settings.haml.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = HamlIcons.Haml;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (COLORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getColorDescriptors"));
        }
        return COLORS;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        HAMLSyntaxHighlighter hAMLSyntaxHighlighter = new HAMLSyntaxHighlighter();
        if (hAMLSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getHighlighter"));
        }
        return hAMLSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if (DEMO_TEXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLColorsPage", "getDemoText"));
        }
        return DEMO_TEXT;
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("attr", HAMLHighlighter.TAG_ATTR_KEY);
        COLORS = new ColorDescriptor[0];
    }
}

