/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.config;

import com.intellij.coldFusion.UI.config.CfmlMappingsConfig;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CfmlProjectConfiguration", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/cfml.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class CfmlProjectConfiguration
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static CfmlProjectConfiguration getInstance(Project project) {
        return (CfmlProjectConfiguration)ServiceManager.getService((Project)project, CfmlProjectConfiguration.class);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        if (state == null) {
            return;
        }
        state.migrateIfNeeded();
    }

    public static class State {
        private CfmlMappingsConfig myMapps = new CfmlMappingsConfig();
        private String myLanguageLevel = "cf10_tags.xml";
        private Element myMappingsElement;
        private Element mySlashMappingElement;

        public State() {
        }

        public State(CfmlMappingsConfig mappings) {
            this.myMapps = mappings;
        }

        @Property(surroundWithTag=false)
        public CfmlMappingsConfig getMapps() {
            return this.myMapps;
        }

        public void setMapps(@Nullable CfmlMappingsConfig mappings) {
            this.myMapps = mappings;
        }

        @Tag(value="mappings")
        public Element getMappingsElement() {
            return this.myMappingsElement;
        }

        public void setMappingsElement(@Nullable Element element) {
            this.myMappingsElement = element;
        }

        @Tag(value="mappings2")
        public Element getSlashMappingElement() {
            return this.mySlashMappingElement;
        }

        public void setSlashMappingElement(@Nullable Element element) {
            this.mySlashMappingElement = element;
        }

        @Tag(value="language_level")
        public String getLanguageLevel() {
            return this.myLanguageLevel;
        }

        public void setLanguageLevel(String languageLevel) {
            this.myLanguageLevel = languageLevel;
        }

        public void updateAndAddIfNeeded(String logicalPath, String directory) {
            if (logicalPath == null || directory == null) {
                return;
            }
            this.myMapps.putToServerMappings(StringUtil.startsWithChar((CharSequence)directory, (char)'/') || StringUtil.startsWithChar((CharSequence)directory, (char)'\\') ? directory : "/" + directory, logicalPath);
        }

        public void migrateIfNeeded() {
            Element firstChild;
            if (this.mySlashMappingElement == null && this.myMappingsElement == null) {
                return;
            }
            Element element = firstChild = this.mySlashMappingElement != null ? this.mySlashMappingElement.getChild("CfmlMappingsConfig") : null;
            if (firstChild == null) {
                firstChild = this.myMappingsElement.getChild("CfmlMappingsConfig");
            }
            if (firstChild != null) {
                for (Element e : JDOMUtil.getChildren((Element)firstChild.getChild("server_mappings"), (String)"mapping")) {
                    this.updateAndAddIfNeeded(e.getAttributeValue("logical_path"), e.getAttributeValue("directory"));
                }
            } else {
                for (Element e : this.myMappingsElement.getChildren("mapping")) {
                    this.myMapps.putToServerMappings(e.getAttributeValue("logical_path"), e.getAttributeValue("directory"));
                }
            }
            this.setMappingsElement(null);
            this.setSlashMappingElement(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.myLanguageLevel != null ? !this.myLanguageLevel.equals(state.myLanguageLevel) : state.myLanguageLevel != null) {
                return false;
            }
            CfmlMappingsConfig m1 = this.myMapps != null ? this.myMapps : new CfmlMappingsConfig();
            CfmlMappingsConfig m2 = state.myMapps != null ? state.myMapps : new CfmlMappingsConfig();
            return Comparing.equal((Object)m1, (Object)m2);
        }

        public int hashCode() {
            int result = this.myMapps != null ? this.myMapps.hashCode() : 0;
            result = 31 * result + (this.myLanguageLevel != null ? this.myLanguageLevel.hashCode() : 0);
            return result;
        }
    }
}

