/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.UI.config.CfmlMappingsConfig;
import com.intellij.coldFusion.UI.config.CfmlProjectConfiguration;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlResolveResult;
import com.intellij.coldFusion.model.psi.stubs.CfmlIndex;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlComponentReference
extends CfmlCompositeElement
implements CfmlReference,
PlatformIcons {
    private PsiElement myParent;
    private final ResolveCache.PolyVariantResolver<CfmlComponentReference> MY_RESOLVER;

    public CfmlComponentReference(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "<init>"));
        }
        super(node);
        this.myParent = null;
        this.MY_RESOLVER = new ResolveCache.PolyVariantResolver<CfmlComponentReference>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull CfmlComponentReference expression, boolean incompleteCode) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/coldFusion/model/psi/CfmlComponentReference$1", "resolve"));
                }
                CfmlImport parentOfType = (CfmlImport)PsiTreeUtil.getParentOfType((PsiElement)expression, CfmlImport.class);
                String componentQualifiedName = parentOfType != null ? CfmlComponentReference.this.getText() : CfmlComponentReference.this.getComponentQualifiedName(CfmlComponentReference.this.getText());
                CfmlFile containingFile = CfmlComponentReference.this.getContainingFile();
                Object object = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
                if (containingFile instanceof CfmlFile) {
                    ResolveResult[] resolveResultArray = CfmlResolveResult.create(CfmlComponentReference.resolveFromQualifiedName(componentQualifiedName, containingFile));
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference$1", "resolve"));
                    }
                    return resolveResultArray;
                }
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference$1", "resolve"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
        };
    }

    public CfmlComponentReference(@NotNull ASTNode node, PsiElement parent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "<init>"));
        }
        this(node);
        this.myParent = parent;
    }

    public String getComponentQualifiedName(String name) {
        return this.getContainingFile().getComponentQualifiedName(name);
    }

    public static Collection<CfmlComponent> resolveFromQualifiedName(String componentQualifiedName, @NotNull CfmlFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "resolveFromQualifiedName"));
        }
        ArrayList<CfmlComponent> result = new ArrayList<CfmlComponent>();
        if (componentQualifiedName == null) {
            return result;
        }
        Project project = originalFile.getProject();
        if (!componentQualifiedName.contains(".")) {
            CfmlFile cfmlConteiningFile = originalFile;
            PsiDirectory directory = cfmlConteiningFile.getParent();
            if (directory != null) {
                GlobalSearchScope searchScope = GlobalSearchScopes.directoryScope((PsiDirectory)directory, (boolean)false);
                Collection<CfmlComponent> components = CfmlIndex.getInstance(project).getComponentsByNameInScope(componentQualifiedName, searchScope);
                components.addAll(CfmlIndex.getInstance(project).getInterfacesByNameInScope(componentQualifiedName, searchScope));
                Iterator iterator = components.iterator();
                while (iterator.hasNext()) {
                    CfmlComponent component = (CfmlComponent)iterator.next();
                    result.add(component);
                }
            } else {
                Collection<CfmlComponent> components = CfmlIndex.getInstance(project).getComponentsByName(componentQualifiedName);
                components.addAll(CfmlIndex.getInstance(project).getInterfacesByName(componentQualifiedName));
                for (CfmlComponent component : components) {
                    result.add(component);
                }
            }
        }
        if (result.isEmpty()) {
            String componentName = CfmlComponentReference.getComponentName(componentQualifiedName);
            int i = componentQualifiedName.lastIndexOf(".");
            String directoryName = i == -1 ? "" : componentQualifiedName.substring(0, i);
            CfmlProjectConfiguration.State state = CfmlProjectConfiguration.getInstance(project).getState();
            CfmlMappingsConfig mappings = state != null ? state.getMapps().clone() : new CfmlMappingsConfig();
            CfmlComponentReference.adjustMappingsIfEmpty(mappings, originalFile.getProject());
            List<String> realPossiblePaths = mappings.mapVirtualToReal(directoryName);
            Collection<CfmlComponent> components = CfmlIndex.getInstance(project).getComponentsByName(componentName);
            components.addAll(CfmlIndex.getInstance(project).getInterfacesByName(componentName));
            block2: for (CfmlComponent component : components) {
                PsiDirectory parent = component.getContainingFile().getParent();
                if (parent == null) continue;
                VirtualFile virtualFile = parent.getVirtualFile();
                for (String realPath : realPossiblePaths) {
                    if (!FileUtil.toSystemIndependentName((String)realPath).equals(FileUtil.toSystemIndependentName((String)virtualFile.getPresentableUrl()))) continue;
                    result.add(component);
                    continue block2;
                }
            }
            for (String realPath : realPossiblePaths) {
                PsiDirectory directory;
                PsiFile file;
                VirtualFile fileByUrl = LocalFileSystem.getInstance().findFileByPath(realPath);
                if (fileByUrl == null || (file = PsiManager.getInstance((Project)project).findFile(fileByUrl)) == null || (directory = file.getParent()) == null) continue;
                GlobalSearchScope searchScope = GlobalSearchScopes.directoryScope((PsiDirectory)directory, (boolean)false);
                Collection<CfmlComponent> componentsFromGlobalScope = CfmlIndex.getInstance(project).getComponentsByNameInScope(componentName, searchScope);
                componentsFromGlobalScope.addAll(CfmlIndex.getInstance(project).getInterfacesByNameInScope(componentName, searchScope));
                for (CfmlComponent component : componentsFromGlobalScope) {
                    result.add(component);
                }
            }
        }
        if (result.isEmpty()) {
            String libtag;
            VirtualFile folder;
            Couple<String> prefixAndName = CfmlUtil.getPrefixAndName(componentQualifiedName);
            String componentName = (String)prefixAndName.getSecond();
            CfmlImport cfmlImport = CfmlUtil.getImportByPrefix((PsiElement)originalFile, (String)prefixAndName.getFirst());
            if (cfmlImport != null && !StringUtil.isEmpty((String)componentName) && (folder = CfmlUtil.findFileByLibTag((PsiFile)originalFile, libtag = cfmlImport.getImportString())) != null && folder.isDirectory()) {
                GlobalSearchScope scope = GlobalSearchScopes.directoryScope((Project)originalFile.getProject(), (VirtualFile)folder, (boolean)true);
                result.addAll(CfmlIndex.getInstance(originalFile.getProject()).getComponentsByNameInScope(componentName, scope));
            }
        }
        return result;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.MY_RESOLVER.resolve((PsiPolyVariantReference)this, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private static String getComponentName(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "getComponentName"));
        }
        int i = componentName.lastIndexOf(46);
        if (i == -1) {
            return componentName;
        }
        if (i == componentName.length() - 1) {
            return "";
        }
        return componentName.substring(i + 1);
    }

    public PsiElement getElement() {
        return this.myParent != null ? this.myParent : this;
    }

    public TextRange getRangeInElement() {
        int offset = 0;
        if (this.myParent != null) {
            int parentOffset = this.myParent.getTextRange().getStartOffset();
            offset = this.getTextRange().getStartOffset() - parentOffset;
        }
        return new TextRange(0, this.getTextLength()).shiftRight(offset);
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented yet");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "bindToElement"));
        }
        throw new IncorrectOperationException("Not implemented yet");
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof CfmlComponent && this.getCanonicalText().equals(((CfmlComponent)element).getName());
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = CfmlComponentReference.buildVariants(this.getText(), (PsiFile)this.getContainingFile(), this.getProject(), this, true);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public static Object[] buildVariants(String text, PsiFile containingFile, final Project project, @Nullable CfmlComponentReference reference, final boolean forceQualify) {
        CfmlProjectConfiguration.State state;
        THashSet variants = new THashSet();
        String directoryName = "";
        if (text.contains(".")) {
            int i = text.lastIndexOf(".");
            directoryName = text.substring(0, i);
        }
        CfmlMappingsConfig mappings = (state = CfmlProjectConfiguration.getInstance(project).getState()) != null ? state.getMapps().clone() : new CfmlMappingsConfig();
        CfmlComponentReference.adjustMappingsIfEmpty(mappings, project);
        if (reference != null) {
            CfmlComponentReference.addFakeMappingsForImports(reference, mappings);
        }
        List<String> realPossiblePaths = mappings.mapVirtualToReal(directoryName);
        for (String realPath : realPossiblePaths) {
            CfmlComponentReference.addVariantsFromPath((Collection<Object>)variants, directoryName, realPath);
        }
        for (String value : mappings.getServerMappings().keySet()) {
            if (!value.startsWith(directoryName) || value.isEmpty() || !StringUtil.startsWithChar((CharSequence)value, (char)'/') && !StringUtil.startsWithChar((CharSequence)value, (char)'\\')) continue;
            variants.add(value.replace('\\', '.').replace('/', '.').substring(1));
        }
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile != null && containingFile instanceof CfmlFile) {
            CfmlFile cfmlContainingFile = (CfmlFile)containingFile;
            if (directoryName.length() == 0) {
                PsiDirectory directory = cfmlContainingFile.getParent();
                if (directory != null) {
                    CfmlComponentReference.addVariantsFromPath((Collection<Object>)variants, "", directory.getVirtualFile().getPresentableUrl());
                }
            } else {
                String dirPath = cfmlContainingFile.getParent().getVirtualFile().getPath() + "/" + directoryName.replaceAll("[./]+", "/");
                CfmlComponentReference.addVariantsFromPath((Collection<Object>)variants, directoryName, dirPath);
            }
        }
        final String finalDirectoryName = directoryName;
        Object[] objectArray = ContainerUtil.map2Array((Collection)variants, (Function)new Function<Object, Object>(){

            public Object fun(Object object) {
                if (object instanceof VirtualFile) {
                    String name;
                    VirtualFile element = (VirtualFile)object;
                    String elementNameWithoutExtension = element.getNameWithoutExtension();
                    String string = forceQualify ? finalDirectoryName + (finalDirectoryName.length() == 0 ? "" : ".") + elementNameWithoutExtension : (name = elementNameWithoutExtension);
                    if (name.length() == 0) {
                        name = element.getName();
                    }
                    if (element.isDirectory()) {
                        return LookupElementBuilder.create((String)name).withIcon(PlatformIcons.DIRECTORY_CLOSED_ICON).withInsertHandler((InsertHandler)new DotInsertHandler()).withCaseSensitivity(false);
                    }
                    Icon icon = PlatformIcons.CLASS_ICON;
                    if (CfmlIndex.getInstance(project).getComponentsByNameInScope(elementNameWithoutExtension, GlobalSearchScope.fileScope((Project)project, (VirtualFile)element)).size() == 1) {
                        icon = PlatformIcons.CLASS_ICON;
                    } else if (CfmlIndex.getInstance(project).getInterfacesByNameInScope(elementNameWithoutExtension, GlobalSearchScope.fileScope((Project)project, (VirtualFile)element)).size() == 1) {
                        icon = PlatformIcons.INTERFACE_ICON;
                    }
                    return LookupElementBuilder.create((String)name).withIcon(icon).withCaseSensitivity(false);
                }
                if (object instanceof String) {
                    return LookupElementBuilder.create((String)((String)object)).withInsertHandler((InsertHandler)new DotInsertHandler()).withCaseSensitivity(false);
                }
                return object;
            }

            class DotInsertHandler
            implements InsertHandler<LookupElement> {
                DotInsertHandler() {
                }

                public void handleInsert(InsertionContext context, LookupElement item) {
                    Document document = context.getDocument();
                    int offset = context.getEditor().getCaretModel().getOffset();
                    document.insertString(offset, (CharSequence)".");
                    context.getEditor().getCaretModel().moveToOffset(offset + 1);
                }
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentReference", "buildVariants"));
        }
        return objectArray;
    }

    private static void adjustMappingsIfEmpty(CfmlMappingsConfig mappings, Project project) {
        if (mappings.getServerMappings().size() != 0) {
            return;
        }
        for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            mappings.putToServerMappings("", root.getPresentableUrl());
        }
    }

    private static void addFakeMappingsForImports(CfmlComponentReference ref, CfmlMappingsConfig mappings) {
        if (PsiTreeUtil.getParentOfType((PsiElement)ref, CfmlImport.class) != null) {
            CfmlFile file = ref.getContainingFile();
            Collection<String> importStrings = file.getImportStrings();
            for (String importString : importStrings) {
                String leftMapping;
                int index = importString.lastIndexOf(46);
                if (index == -1 || StringUtil.isEmpty((String)(leftMapping = file.getComponentQualifiedName(importString).substring(0, index)))) continue;
                mappings.putToServerMappings("", leftMapping);
            }
        }
    }

    private static void addVariantsFromPath(Collection<Object> variants, String directoryName, String realPath) {
        VirtualFile fileByUrl = LocalFileSystem.getInstance().findFileByPath(realPath);
        if (fileByUrl != null && fileByUrl.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = fileByUrl.getChildren()) {
                if (!child.isDirectory() && !"cfc".equals(child.getExtension())) continue;
                variants.add(child);
            }
        }
    }

    public boolean isSoft() {
        return true;
    }

    public String getName() {
        String referenceText = this.getCanonicalText();
        int index = referenceText.lastIndexOf(".");
        return referenceText != null ? referenceText.substring(index >= 0 ? index + 1 : 0) : "";
    }

    @Override
    public PsiType getPsiType() {
        return null;
    }

    public PsiReference getReference() {
        return this;
    }
}

