/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlProperty;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlSuperComponentReference;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentStub;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CfmlComponentImpl
extends CfmlCompositeElement
implements CfmlComponent,
StubBasedPsiElement<NamedStub> {
    public CfmlComponentImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "<init>"));
        }
        super(node);
    }

    public CfmlComponentImpl(@NotNull NamedStub<CfmlComponent> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "<init>"));
        }
        super(stub, CfmlStubElementTypes.COMPONENT_DEFINITION);
    }

    public String getName() {
        String nameFromFile = CfmlUtil.getFileName(this);
        if (!StringUtil.isEmpty((String)nameFromFile)) {
            return nameFromFile;
        }
        PsiElement nameElement = this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
        if (nameElement != null) {
            return nameElement.getText();
        }
        return "";
    }

    @Override
    @NotNull
    public CfmlFunction[] getFunctions() {
        CfmlFunction[] childrenOfType = (CfmlFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)this, CfmlFunction.class);
        CfmlFunction[] cfmlFunctionArray = childrenOfType == null ? CfmlFunction.EMPTY_ARRAY : childrenOfType;
        if (cfmlFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getFunctions"));
        }
        return cfmlFunctionArray;
    }

    @Override
    @NotNull
    public CfmlFunction[] getFunctionsWithSupers(boolean isSuperPriority) {
        CfmlFunction[] cfmlFunctionArray = CfmlPsiUtil.getFunctionsWithSupers(this, isSuperPriority);
        if (cfmlFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getFunctionsWithSupers"));
        }
        return cfmlFunctionArray;
    }

    @Override
    @NotNull
    public CfmlProperty[] getProperties() {
        CfmlProperty[] childrenOfType = (CfmlProperty[])PsiTreeUtil.getChildrenOfType((PsiElement)this, CfmlProperty.class);
        CfmlProperty[] cfmlPropertyArray = childrenOfType == null ? CfmlProperty.EMPTY_ARRAY : childrenOfType;
        if (cfmlPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getProperties"));
        }
        return cfmlPropertyArray;
    }

    @Override
    @NotNull
    public CfmlProperty[] getPropertiesWithSupers(boolean isSuperPriority) {
        CfmlProperty[] cfmlPropertyArray = CfmlPsiUtil.getPropertiesWithSupers(this, isSuperPriority);
        if (cfmlPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getPropertiesWithSupers"));
        }
        return cfmlPropertyArray;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "setName"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        CfmlProperty[] propertiesWithSupers;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "processDeclarations"));
        }
        if (!CfmlPsiUtil.processDeclarations(processor, state, lastParent, this)) {
            return false;
        }
        for (CfmlFunction function : this.getFunctionsWithSupers(place.getFirstChild() instanceof CfmlSuperComponentReference)) {
            if (processor.execute((PsiElement)function, state)) continue;
            return false;
        }
        for (CfmlProperty property : propertiesWithSupers = this.getPropertiesWithSupers(place.getFirstChild() instanceof CfmlSuperComponentReference)) {
            if (processor.execute((PsiElement)property, state)) continue;
            return false;
        }
        return CfmlPsiUtil.processGlobalVariablesForComponent(this, processor, state, lastParent);
    }

    @Override
    public boolean isInterface() {
        return this.getNode().getFirstChildNode().getElementType() == CfscriptTokenTypes.INTERFACE_KEYWORD;
    }

    @Override
    @NotNull
    public String getSuperName() {
        if (this.isInterface()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getSuperName"));
            }
            return "";
        }
        if (this.getStub() != null) {
            String string = ((CfmlComponentStub)this.getStub()).getSuperclass();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getSuperName"));
            }
            return string;
        }
        String string = CfmlPsiUtil.getSuperComponentName(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getSuperName"));
        }
        return string;
    }

    @Override
    public String[] getInterfaceNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public CfmlComponent[] getImplementedInterfaces() {
        return new CfmlComponent[0];
    }

    @Override
    public CfmlComponent getSuper() {
        return CfmlPsiUtil.getSuperComponent(this);
    }

    @Override
    public CfmlComponentReference getSuperReference() {
        return CfmlPsiUtil.getSuperComponentReference(this);
    }

    @Override
    public boolean isTrulyDeclaration() {
        return true;
    }

    public PsiElement getNameIdentifier() {
        return this.getNavigationElement();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = CfmlPsiUtil.getComponentReferencesFromAttributes(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/coldFusion/model/psi/impl/CfmlComponentImpl", "accept"));
        }
        if (visitor instanceof CfmlRecursiveElementVisitor) {
            ((CfmlRecursiveElementVisitor)visitor).visitCfmlComponent(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean hasImplicitAccessors() {
        PsiElement accessors = CfmlPsiUtil.getAttributeValueElement(this, "accessors");
        if (accessors == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(accessors.getText()) || "true".equalsIgnoreCase(accessors.getText());
    }

    @Override
    public boolean isPersistent() {
        PsiElement persistentEl = CfmlPsiUtil.getAttributeValueElement(this, "persistent");
        if (persistentEl == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(persistentEl.getText()) || "true".equalsIgnoreCase(persistentEl.getText());
    }
}

