/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.mxunit;

import com.intellij.coldFusion.UI.editorActions.CfmlScriptNodeSuppressor;
import com.intellij.coldFusion.mxunit.CfmlUnitRunConfiguration;
import com.intellij.coldFusion.mxunit.CfmlUnitRunnerParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class CfmlUnitRemoteTestsRunner {
    private static final Logger LOG = Logger.getInstance((String)CfmlUnitRemoteTestsRunner.class.getName());

    public static String getLauncherText(String resourcePath) {
        try {
            return ResourceUtil.loadText((URL)CfmlUnitRunConfiguration.class.getResource(resourcePath)).replaceFirst("\\Q/*system_delimiter*/\\E", ("" + File.separatorChar).replace("\\", "\\\\\\\\"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(Project project, final VirtualFile file) throws ExecutionException {
        final Ref error = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (file.isValid()) {
                                file.delete((Object)this);
                            }
                        }
                        catch (IOException e) {
                            error.set((Object)e);
                        }
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            ApplicationManager.getApplication().invokeAndWait(runnable, pi != null ? pi.getModalityState() : ModalityState.NON_MODAL);
        }
        if (!error.isNull()) {
            throw new ExecutionException(((IOException)error.get()).getMessage());
        }
    }

    public static VirtualFile createFile(Project project, final VirtualFile directory, final String fileName, final String fileText) throws ExecutionException {
        LOG.assertTrue(directory != null);
        final Ref error = new Ref();
        final Ref launcherFile = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualFile file = directory.findChild(fileName);
                            if (file == null) {
                                file = directory.createChildData(CfmlUnitRunConfiguration.class, fileName);
                            }
                            CfmlScriptNodeSuppressor.suppress(file);
                            VfsUtil.saveText((VirtualFile)file, (String)fileText);
                            launcherFile.set((Object)file);
                        }
                        catch (IOException e) {
                            error.set((Object)e);
                        }
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            ApplicationManager.getApplication().invokeAndWait(runnable, pi != null ? pi.getModalityState() : ModalityState.NON_MODAL);
        }
        if (!error.isNull()) {
            throw new ExecutionException(((IOException)error.get()).getMessage());
        }
        return (VirtualFile)launcherFile.get();
    }

    private static String generateUniqueName(String prefix, Project project) {
        return prefix + "_" + project.getName().replaceAll("[^\\p{Alnum}]", "_") + "_" + SystemProperties.getUserName().replaceAll("[^\\p{Alnum}]", "_") + ".cfc";
    }

    public static void executeScript(final CfmlUnitRunnerParameters params, final ProcessHandler processHandler, final Project project) throws ExecutionException {
        final Ref ref = new Ref();
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String agentUrl;
                    VirtualFile componentFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(params.getPath());
                    if (componentFile == null) {
                        throw new ExecutionException("File " + params.getPath() + " not found");
                    }
                    VirtualFile directory = componentFile.getParent();
                    String launcherFileName = "mxunit-launcher.cfc";
                    LOG.debug("Copying script filemxunit-launcher.cfc to component folder: " + directory);
                    CfmlUnitRemoteTestsRunner.createFile(project, directory, "mxunit-launcher.cfc", CfmlUnitRemoteTestsRunner.getLauncherText("/scripts/mxunit-launcher.cfc"));
                    String resultsFileName = "mxunit-result-capture.cfc";
                    LOG.debug("Copying results capture file mxunit-result-capture.cfc to component folder: " + directory);
                    CfmlUnitRemoteTestsRunner.createFile(project, directory, "mxunit-result-capture.cfc", CfmlUnitRemoteTestsRunner.getLauncherText("/scripts/mxunit-result-capture.cfc"));
                    String webPath = params.getWebPath();
                    if (webPath.endsWith("/") || webPath.endsWith("\\")) {
                        webPath = webPath.substring(0, webPath.length() - 1);
                    }
                    String agentPath = webPath.substring(0, webPath.lastIndexOf(47)) + "/" + "mxunit-launcher.cfc";
                    LOG.debug("Retrieving data from coldfusion server by " + agentPath + " URL");
                    BufferedReader reader = null;
                    if (params.getScope() == CfmlUnitRunnerParameters.Scope.Directory) {
                        agentUrl = agentPath + "?method=executeDirectory&directoryName=" + componentFile.getName();
                    } else {
                        agentUrl = agentPath + "?method=executeTestCase&componentName=" + componentFile.getNameWithoutExtension();
                        if (params.getScope() == CfmlUnitRunnerParameters.Scope.Method) {
                            agentUrl = agentUrl + "&methodName=" + params.getMethod();
                        }
                    }
                    GetMethod method = null;
                    try {
                        String line;
                        LOG.debug("Retrieving test results from: " + agentUrl);
                        HttpClient client = new HttpClient();
                        method = new GetMethod(agentUrl);
                        int statusCode = client.executeMethod((HttpMethod)method);
                        if (statusCode != 200) {
                            LOG.debug("Http request failed: " + method.getStatusLine());
                            processHandler.notifyTextAvailable("Http request failed: " + method.getStatusLine(), ProcessOutputTypes.SYSTEM);
                        }
                        InputStream responseStream = method.getResponseBodyAsStream();
                        reader = new BufferedReader(new InputStreamReader(responseStream));
                        while (!processHandler.isProcessTerminating() && !processHandler.isProcessTerminated() && (line = reader.readLine()) != null) {
                            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
                            LOG.debug("MXUnit: " + line);
                            processHandler.notifyTextAvailable(line + "\n", ProcessOutputTypes.SYSTEM);
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        processHandler.notifyTextAvailable("Failed to retrieve test results from the server at " + agentUrl + "\n", ProcessOutputTypes.SYSTEM);
                    }
                    finally {
                        if (method != null) {
                            method.releaseConnection();
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    LOG.debug("Cleaning temporary files");
                    CfmlUnitRemoteTestsRunner.deleteFile(project, directory.findChild("mxunit-launcher.cfc"));
                    CfmlUnitRemoteTestsRunner.deleteFile(project, directory.findChild("mxunit-result-capture.cfc"));
                    if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                        processHandler.destroyProcess();
                    }
                }
                catch (ExecutionException e) {
                    ref.set((Object)e);
                }
            }
        });
        if (!ref.isNull()) {
            throw (ExecutionException)((Object)ref.get());
        }
    }
}

