/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateConstraintValidatorFix
extends BaseBVQuickFix
implements IntentionAction {
    private final PsiJavaCodeReferenceElement myRef;
    private final PsiClass myConstraint;

    public CreateConstraintValidatorFix(PsiJavaCodeReferenceElement ref, PsiClass constraint) {
        super(BVInspectionBundle.message("create.constraint.validator", ref.getCanonicalText()));
        this.myRef = ref;
        this.myConstraint = constraint;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix", "invoke"));
        }
        throw new IncorrectOperationException();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix", "applyFix"));
        }
        final PsiJavaCodeReferenceElement element = this.myRef;
        assert (element != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        final PsiClass aClass = CreateFromUsageUtils.createClass((PsiJavaCodeReferenceElement)element, (CreateClassKind)CreateClassKind.CLASS, null);
        if (aClass != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(PsiDocumentManager.getInstance((Project)project).getDocument(aClass.getContainingFile()));
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    PsiJavaCodeReferenceElement refElement = element;
                    if (aClass == null) {
                        return;
                    }
                    try {
                        refElement = (PsiJavaCodeReferenceElement)refElement.bindToElement((PsiElement)aClass);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                    StringBuilder template = new StringBuilder();
                    int nameOffset = aClass.getNameIdentifier().getTextOffset() + aClass.getNameIdentifier().getTextLength();
                    int leftBraceOffset = aClass.getLBrace().getTextOffset();
                    template.append(" implements ").append("javax.validation.ConstraintValidator").append("<").append(CreateConstraintValidatorFix.this.myConstraint.getQualifiedName()).append(", $type$> {");
                    template.append("\n   public void initialize(").append(CreateConstraintValidatorFix.this.myConstraint.getQualifiedName()).append(" constraint) {\n   }\n\n").append("   public boolean isValid($type$ $name$, ").append("javax.validation.ConstraintValidatorContext").append(" context) {\n      return false;\n   }");
                    IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(refElement.getProject(), aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
                    String fqn = aClass.getQualifiedName();
                    Editor editor = FileEditorManager.getInstance((Project)aClass.getProject()).openTextEditor(descriptor, true);
                    editor.getSelectionModel().setSelection(nameOffset, leftBraceOffset + 1);
                    Template temp = TemplateManager.getInstance((Project)project).createTemplate("", "", template.toString());
                    temp.addVariable("type", "\"String\"", "String", true);
                    temp.addVariable("name", "\"obj\"", "obj", true);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, "", temp);
                    PsiExpression expression = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(fqn + ".class", (PsiElement)CreateConstraintValidatorFix.this.myConstraint.getModifierList());
                    CreateConstraintValidatorFix.this.myConstraint.getModifierList().findAnnotation("javax.validation.Constraint").findAttributeValue("validatedBy").replace((PsiElement)expression);
                }
            });
        }
    }
}

