/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVTypeNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.AnnotationTypeNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVModuleNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVNodeTypes;
import com.intellij.beanValidation.toolWindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.SortedList;
import icons.BVCoreIcons;
import java.util.Collection;
import java.util.Comparator;

public class ConstraintsNode
extends AbstractBVTypeNode {
    private static Comparator<PsiMemberSimpleNode> COMPARATOR = new Comparator<PsiMemberSimpleNode>(){

        @Override
        public int compare(PsiMemberSimpleNode o1, PsiMemberSimpleNode o2) {
            boolean b2;
            Object m1 = o1.getMember();
            Object m2 = o2.getMember();
            boolean b1 = BVUtils.isInLibrary(m1);
            return b1 == (b2 = BVUtils.isInLibrary(m2)) ? Comparing.compare((Comparable)((Object)m1.getName()), (Comparable)((Object)m2.getName())) : (b1 ? 1 : -1);
        }
    };

    public ConstraintsNode(Module module, BVModuleNode moduleNode) {
        super(moduleNode, module, BVNodeTypes.CONSTRAINTS, BVBundle.message("actions.show.constraints", new Object[0]));
    }

    @Override
    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(BVCoreIcons.Constraints);
    }

    @Override
    public SimpleNode[] getChildren() {
        Collection<PsiClass> deploymentTypesClasses = BVUtils.getConstraintClasses(this.getModule());
        SortedList nodes = new SortedList(COMPARATOR);
        for (PsiClass psiClass : deploymentTypesClasses) {
            nodes.add(new AnnotationTypeNode(this.getModule(), psiClass, this));
        }
        return nodes.toArray(new SimpleNode[nodes.size()]);
    }
}

