/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.enhancement;

import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.DummyPersistentState;
import com.intellij.openapi.compiler.generic.VirtualFileWithDependenciesState;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassFileItem
extends CompileItem<String, VirtualFileWithDependenciesState, DummyPersistentState> {
    private final VirtualFile myClassFile;
    private final VirtualFile mySourceFile;
    private final List<VirtualFile> myDependencies;

    public ClassFileItem(VirtualFile classFile, VirtualFile sourceFile, List<VirtualFile> dependencies) {
        this.myClassFile = classFile;
        this.mySourceFile = sourceFile;
        this.myDependencies = dependencies;
    }

    @NotNull
    public String getKey() {
        String string = this.myClassFile.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/enhancement/ClassFileItem", "getKey"));
        }
        return string;
    }

    public boolean isSourceUpToDate(@NotNull VirtualFileWithDependenciesState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/appengine/enhancement/ClassFileItem", "isSourceUpToDate"));
        }
        return state.isUpToDate(this.myClassFile);
    }

    @NotNull
    public VirtualFileWithDependenciesState computeSourceState() {
        VirtualFileWithDependenciesState state = new VirtualFileWithDependenciesState(this.myClassFile.getTimeStamp());
        for (VirtualFile dependency : this.myDependencies) {
            state.addDependency(dependency);
        }
        VirtualFileWithDependenciesState virtualFileWithDependenciesState = state;
        if (virtualFileWithDependenciesState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/enhancement/ClassFileItem", "computeSourceState"));
        }
        return virtualFileWithDependenciesState;
    }

    public boolean isOutputUpToDate(@NotNull DummyPersistentState dummyPersistentState) {
        if (dummyPersistentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyPersistentState", "com/intellij/appengine/enhancement/ClassFileItem", "isOutputUpToDate"));
        }
        return true;
    }

    @NotNull
    public DummyPersistentState computeOutputState() {
        DummyPersistentState dummyPersistentState = DummyPersistentState.INSTANCE;
        if (dummyPersistentState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/enhancement/ClassFileItem", "computeOutputState"));
        }
        return dummyPersistentState;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myClassFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/enhancement/ClassFileItem", "getFile"));
        }
        return virtualFile;
    }

    public VirtualFile getSourceFile() {
        return this.mySourceFile;
    }
}

