/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineFacetConfiguration;
import com.intellij.appengine.facet.AppEngineFrameworkType;
import com.intellij.appengine.facet.AppEngineSdkEditor;
import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.facet.PersistenceApiComboboxUtil;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.impl.AppEngineSdkUtil;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.appengine.model.PersistenceApi;

public class AppEngineSupportProvider
extends FrameworkSupportInModuleProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.appengine.facet.AppEngineSupportProvider");
    public static final String JPA_FRAMEWORK_ID = "facet:jpa";

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        AppEngineFrameworkType appEngineFrameworkType = AppEngineFrameworkType.getFrameworkType();
        if (appEngineFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineSupportProvider", "getFrameworkType"));
        }
        return appEngineFrameworkType;
    }

    public List<FrameworkSupportInModuleProvider.FrameworkDependency> getDependenciesFrameworkIds() {
        return Arrays.asList(FrameworkSupportInModuleProvider.FrameworkDependency.required((String)"web"), FrameworkSupportInModuleProvider.FrameworkDependency.optional((String)JPA_FRAMEWORK_ID));
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/appengine/facet/AppEngineSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/AppEngineSupportProvider", "isSupportAlreadyAdded"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/appengine/facet/AppEngineSupportProvider", "isSupportAlreadyAdded"));
        }
        return !facetsProvider.getFacetsByType(module, AppEngineFacet.ID).isEmpty();
    }

    @Nullable
    public static VirtualFile createFileFromTemplate(String templateName, VirtualFile parent, String fileName) {
        parent.refresh(false, false);
        FileTemplate template = FileTemplateManager.getDefaultInstance().getJ2eeTemplate(templateName);
        try {
            String text = template.getText(FileTemplateManager.getDefaultInstance().getDefaultProperties());
            VirtualFile file = parent.findChild(fileName);
            if (file == null) {
                file = parent.createChildData(AppEngineSupportProvider.class, fileName);
            }
            VfsUtil.saveText((VirtualFile)file, (String)text);
            return file;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private void addSupport(Module module, ModifiableRootModel rootModel, FrameworkSupportModel frameworkSupportModel, String sdkPath, @Nullable PersistenceApi persistenceApi) {
        VirtualFile descriptor;
        FacetType<AppEngineFacet, AppEngineFacetConfiguration> facetType = AppEngineFacet.getFacetType();
        AppEngineFacet appEngineFacet = (AppEngineFacet)FacetManager.getInstance((Module)module).addFacet(facetType, facetType.getDefaultFacetName(), null);
        AppEngineWebIntegration webIntegration = AppEngineWebIntegration.getInstance();
        webIntegration.registerFrameworkInModel(frameworkSupportModel, appEngineFacet);
        AppEngineFacetConfiguration facetConfiguration = (AppEngineFacetConfiguration)appEngineFacet.getConfiguration();
        facetConfiguration.setSdkHomePath(sdkPath);
        AppEngineSdk sdk = appEngineFacet.getSdk();
        Artifact webArtifact = AppEngineSupportProvider.findOrCreateWebArtifact(appEngineFacet);
        VirtualFile webDescriptorDir = webIntegration.suggestParentDirectoryForAppEngineWebXml(module, rootModel);
        if (webDescriptorDir != null && (descriptor = AppEngineSupportProvider.createFileFromTemplate("AppEngineWeb.xml", webDescriptorDir, "appengine-web.xml")) != null) {
            webIntegration.addDescriptor(webArtifact, module.getProject(), descriptor);
        }
        Project project = module.getProject();
        webIntegration.addDevServerToModuleDependencies(rootModel, sdk);
        Library apiJar = AppEngineSupportProvider.addProjectLibrary(module, "AppEngine API", sdk.getUserLibraryPaths(), VirtualFile.EMPTY_ARRAY);
        rootModel.addLibraryEntry(apiJar);
        webIntegration.addLibraryToArtifact(apiJar, webArtifact, project);
        if (persistenceApi != null) {
            facetConfiguration.setRunEnhancerOnMake(true);
            facetConfiguration.setPersistenceApi(persistenceApi);
            facetConfiguration.getFilesToEnhance().addAll(AppEngineUtil.getDefaultSourceRootsToEnhance((ModuleRootModel)rootModel));
            try {
                VirtualFile[] sourceRoots = rootModel.getSourceRoots();
                VirtualFile sourceRoot = sourceRoots.length > 0 ? sourceRoots[0] : this.findOrCreateChildDirectory(rootModel.getContentRoots()[0], "src");
                VirtualFile metaInf = this.findOrCreateChildDirectory(sourceRoot, "META-INF");
                if (persistenceApi == PersistenceApi.JDO || persistenceApi == PersistenceApi.JDO3) {
                    AppEngineSupportProvider.createFileFromTemplate("AppEngineJdoConfig.xml", metaInf, "jdoconfig.xml");
                } else {
                    VirtualFile file = AppEngineSupportProvider.createFileFromTemplate("AppEngineJpaConfig.xml", metaInf, "persistence.xml");
                    if (file != null) {
                        webIntegration.setupJpaSupport(module, file);
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            Library library = AppEngineSupportProvider.addProjectLibrary(module, "AppEngine ORM", Collections.singletonList(sdk.getOrmLibDirectoryPath()), sdk.getOrmLibSources());
            rootModel.addLibraryEntry(library);
            webIntegration.addLibraryToArtifact(library, webArtifact, project);
        }
    }

    @NotNull
    private static Artifact findOrCreateWebArtifact(AppEngineFacet appEngineFacet) {
        Module module = appEngineFacet.getModule();
        ArtifactType webArtifactType = AppEngineWebIntegration.getInstance().getAppEngineWebArtifactType();
        Collection artifacts = ArtifactUtil.getArtifactsContainingModuleOutput((Module)module);
        for (Artifact artifact : artifacts) {
            if (!webArtifactType.equals(artifact.getArtifactType())) continue;
            Artifact artifact2 = artifact;
            if (artifact2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineSupportProvider", "findOrCreateWebArtifact"));
            }
            return artifact2;
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)module.getProject());
        PackagingElementFactory elementFactory = PackagingElementFactory.getInstance();
        ArtifactRootElement root = elementFactory.createArtifactRootElement();
        elementFactory.getOrCreateDirectory((CompositePackagingElement)root, "WEB-INF/classes").addOrFindChild(elementFactory.createModuleOutput(module));
        Artifact artifact = artifactManager.addArtifact(module.getName(), webArtifactType, (CompositePackagingElement)root);
        if (artifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineSupportProvider", "findOrCreateWebArtifact"));
        }
        return artifact;
    }

    private static Library addProjectLibrary(final Module module, final String name, final List<String> jarDirectories, final VirtualFile[] sources) {
        return (Library)new WriteAction<Library>(){

            protected void run(@NotNull Result<Library> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/appengine/facet/AppEngineSupportProvider$1", "run"));
                }
                LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(module.getProject());
                Library library = libraryTable.getLibraryByName(name);
                if (library == null) {
                    library = libraryTable.createLibrary(name);
                    Library.ModifiableModel model = library.getModifiableModel();
                    for (String path : jarDirectories) {
                        String url = VfsUtilCore.pathToUrl((String)path);
                        VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
                        model.addJarDirectory(url, false);
                    }
                    for (VirtualFile sourceRoot : sources) {
                        model.addRoot(sourceRoot, OrderRootType.SOURCES);
                    }
                    model.commit();
                }
                result.setResult((Object)library);
            }
        }.execute().getResultObject();
    }

    private VirtualFile findOrCreateChildDirectory(VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        if (child != null) {
            return child;
        }
        return parent.createChildDirectory((Object)this, name);
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/appengine/facet/AppEngineSupportProvider", "createConfigurable"));
        }
        AppEngineSupportConfigurable appEngineSupportConfigurable = new AppEngineSupportConfigurable(model);
        if (appEngineSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineSupportProvider", "createConfigurable"));
        }
        return appEngineSupportConfigurable;
    }

    public static void setSdkPath(FrameworkSupportInModuleConfigurable configurable, String path) {
        ((AppEngineSupportConfigurable)configurable).mySdkEditor.setPath(path);
    }

    private class AppEngineSupportConfigurable
    extends FrameworkSupportInModuleConfigurable
    implements FrameworkSupportModelListener {
        private final FrameworkSupportModel myFrameworkSupportModel;
        private JPanel myMainPanel;
        private final AppEngineSdkEditor mySdkEditor;
        private JComboBox myPersistenceApiComboBox;
        private JPanel mySdkPanel;
        private final HyperlinkLabel myErrorLabel;
        private JPanel myErrorPanel;

        private AppEngineSupportConfigurable(FrameworkSupportModel model) {
            this.myFrameworkSupportModel = model;
            this.$$$setupUI$$$();
            this.mySdkEditor = new AppEngineSdkEditor(model.getProject());
            this.mySdkPanel.add((Component)LabeledComponent.create((JComponent)this.mySdkEditor.getMainComponent(), (String)"Google App Engine SDK:"), "Center");
            PersistenceApiComboboxUtil.setComboboxModel(this.myPersistenceApiComboBox, true);
            if (model.isFrameworkSelected(AppEngineSupportProvider.JPA_FRAMEWORK_ID)) {
                this.myPersistenceApiComboBox.setSelectedItem(PersistenceApi.JPA.getDisplayName());
            }
            model.addFrameworkListener((FrameworkSupportModelListener)this);
            this.myErrorLabel = new HyperlinkLabel();
            this.myErrorLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
            this.myErrorLabel.setVisible(false);
            this.myErrorLabel.setHyperlinkTarget("http://code.google.com/appengine/downloads.html#Google_App_Engine_SDK_for_Java");
            this.myErrorPanel.add("Center", (Component)this.myErrorLabel);
            Component component = this.mySdkEditor.getComboBox().getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        AppEngineSupportConfigurable.this.checkSdk();
                    }
                });
            }
            this.checkSdk();
        }

        private void checkSdk() {
            String path = this.mySdkEditor.getPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                this.myErrorLabel.setVisible(true);
                this.myErrorLabel.setHyperlinkText("App Engine SDK path not specified. ", "Download", "");
                this.myMainPanel.repaint();
                return;
            }
            ValidationResult result = AppEngineSdkUtil.checkPath(path);
            this.myErrorLabel.setVisible(!result.isOk());
            if (!result.isOk()) {
                this.myErrorLabel.setText("App Engine SDK path is not correct");
            }
            this.myMainPanel.repaint();
        }

        public void frameworkSelected(@NotNull FrameworkSupportProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/appengine/facet/AppEngineSupportProvider$AppEngineSupportConfigurable", "frameworkSelected"));
            }
            if (provider.getId().equals(AppEngineSupportProvider.JPA_FRAMEWORK_ID)) {
                this.myPersistenceApiComboBox.setSelectedItem(PersistenceApi.JPA.getDisplayName());
            }
        }

        public void frameworkUnselected(@NotNull FrameworkSupportProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/appengine/facet/AppEngineSupportProvider$AppEngineSupportConfigurable", "frameworkUnselected"));
            }
            if (provider.getId().equals(AppEngineSupportProvider.JPA_FRAMEWORK_ID)) {
                this.myPersistenceApiComboBox.setSelectedItem("None");
            }
        }

        public void wizardStepUpdated() {
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/AppEngineSupportProvider$AppEngineSupportConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/appengine/facet/AppEngineSupportProvider$AppEngineSupportConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/appengine/facet/AppEngineSupportProvider$AppEngineSupportConfigurable", "addSupport"));
            }
            AppEngineSupportProvider.this.addSupport(module, rootModel, this.myFrameworkSupportModel, this.mySdkEditor.getPath(), PersistenceApiComboboxUtil.getSelectedApi(this.myPersistenceApiComboBox));
        }

        @Nullable
        public JComponent createComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            JComboBox jComboBox;
            JPanel jPanel3;
            this.myMainPanel = jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myPersistenceApiComboBox = jComboBox = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            jComboBox.setModel(defaultComboBoxModel);
            jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Persistence:");
            jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.mySdkPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(0, 0));
            jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myErrorPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }
    }
}

