/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.patterns.ElementPattern;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.facet.SeamFacetConfiguration;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.util.indexing.FileContent;
import icons.SeamIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SeamFacetType
extends FacetType<SeamFacet, SeamFacetConfiguration> {
    SeamFacetType() {
        super(SeamFacet.FACET_TYPE_ID, "Seam", SeamBundle.message("seam.framework.name", new Object[0]));
    }

    public static SeamFacetType getInstance() {
        return (SeamFacetType)SeamFacetType.findInstance(SeamFacetType.class);
    }

    public SeamFacetConfiguration createDefaultConfiguration() {
        return new SeamFacetConfiguration();
    }

    public SeamFacet createFacet(@NotNull Module module, String name, @NotNull SeamFacetConfiguration configuration, Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/facet/SeamFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/seam/facet/SeamFacetType", "createFacet"));
        }
        return new SeamFacet(this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    public Icon getIcon() {
        return SeamIcons.Seam;
    }

    public static class SeamFrameworkDetector
    extends FacetBasedFrameworkDetector<SeamFacet, SeamFacetConfiguration> {
        public SeamFrameworkDetector() {
            super("seam");
        }

        public FacetType<SeamFacet, SeamFacetConfiguration> getFacetType() {
            return SeamFacetType.getInstance();
        }

        @NotNull
        public FileType getFileType() {
            LanguageFileType languageFileType = StdFileTypes.XML;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/facet/SeamFacetType$SeamFrameworkDetector", "getFileType"));
            }
            return languageFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("components.xml").xmlWithRootTag("components");
            if (fileContentPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/facet/SeamFacetType$SeamFrameworkDetector", "createSuitableFilePattern"));
            }
            return fileContentPattern;
        }
    }
}

