/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl.model.metadata;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.seam.model.metadata.SeamEventType;
import com.intellij.seam.model.metadata.SeamEventTypeFactory;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SeamEventTypeFactoryImpl
extends SeamEventTypeFactory {
    private final Map<String, SeamEventType> myEvents = new THashMap();
    private final PsiFile myDummyFile;

    public SeamEventTypeFactoryImpl(Project project) {
        this.myDummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", "");
    }

    @Override
    @NotNull
    public SeamEventType getOrCreateEventType(String eventType) {
        if (!this.myEvents.containsKey(eventType)) {
            this.myEvents.put(eventType, new SeamEventType(eventType, this.myDummyFile));
        }
        SeamEventType seamEventType = this.myEvents.get(eventType);
        if (seamEventType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/metadata/SeamEventTypeFactoryImpl", "getOrCreateEventType"));
        }
        return seamEventType;
    }

    public void dispose() {
        this.myEvents.clear();
    }
}

