/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.seam.model.jam.MergedSeamComponent;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SeamJamModel {
    private static final Key<CachedValue<MergedSeamComponent>> MERGED_SEAM_COMPONENT = Key.create((String)"MERGED_SEAM_COMPONENT");
    private final Module myModule;

    public static SeamJamModel getModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/model/jam/SeamJamModel", "getModel"));
        }
        return (SeamJamModel)ModuleServiceManager.getService((Module)module, SeamJamModel.class);
    }

    public SeamJamModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/model/jam/SeamJamModel", "<init>"));
        }
        this.myModule = module;
    }

    public Module getModule() {
        return this.myModule;
    }

    public List<SeamJamComponent> getAnnotatedSeamComponents(boolean showFromLibraries) {
        return this.getJamClassElements(SeamJamComponent.META, "org.jboss.seam.annotations.Name", showFromLibraries);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamClassMeta<T> clazz, String anno, boolean showFromLibraries) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = this.getScope(showFromLibraries);
        return service.getJamClassElements(clazz, anno, scope);
    }

    private GlobalSearchScope getScope(boolean showFromLibraries) {
        return showFromLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule) : GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule);
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents() {
        Set<SeamJamComponent> set = this.getSeamComponents(true);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/SeamJamModel", "getSeamComponents"));
        }
        return set;
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents(boolean mergeDomComponents) {
        Set<SeamJamComponent> set = this.getSeamComponents(mergeDomComponents, true);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/SeamJamModel", "getSeamComponents"));
        }
        return set;
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents(boolean mergeDomComponents, boolean fromLibs) {
        HashSet<SeamJamComponent> components = new HashSet<SeamJamComponent>();
        List<SeamJamComponent> annotated = this.getAnnotatedSeamComponents(fromLibs);
        components.addAll(annotated);
        if (mergeDomComponents) {
            components.addAll(this.getMergedComponents(annotated));
        }
        HashSet<SeamJamComponent> hashSet = components;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/SeamJamModel", "getSeamComponents"));
        }
        return hashSet;
    }

    public List<SeamJamComponent> getMergedComponents(boolean fromLibs) {
        return this.getMergedComponents(this.getAnnotatedSeamComponents(fromLibs));
    }

    public List<SeamJamComponent> getMergedComponents(List<SeamJamComponent> annotated) {
        ArrayList<SeamJamComponent> mergedComponents = new ArrayList<SeamJamComponent>();
        Module module = this.getModule();
        if (module != null) {
            List psiTypes = ContainerUtil.mapNotNull(annotated, (Function)new Function<SeamJamComponent, PsiType>(){

                public PsiType fun(SeamJamComponent seamJamComponent) {
                    return seamJamComponent.getComponentType();
                }
            });
            for (SeamDomModel model : SeamDomModelManager.getInstance(module.getProject()).getAllModels(module)) {
                for (SeamDomComponent domComponent : model.getSeamComponents()) {
                    PsiClass psiClass;
                    PsiType type;
                    if (psiTypes.contains(domComponent.getComponentType()) || !((type = domComponent.getComponentType()) instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null) continue;
                    mergedComponents.add(this.getOrCreateMergedComponent(psiClass, domComponent));
                }
            }
        }
        return mergedComponents;
    }

    @NotNull
    private MergedSeamComponent getOrCreateMergedComponent(final PsiClass psiClass, final SeamDomComponent domComponent) {
        CachedValue cachedValue = (CachedValue)psiClass.getUserData(MERGED_SEAM_COMPONENT);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<MergedSeamComponent>(){

                public CachedValueProvider.Result<MergedSeamComponent> compute() {
                    MergedSeamComponent mergedSeamComponent = new MergedSeamComponent(psiClass, domComponent);
                    return new CachedValueProvider.Result((Object)mergedSeamComponent, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            }, false);
            psiClass.putUserData(MERGED_SEAM_COMPONENT, (Object)cachedValue);
        }
        MergedSeamComponent mergedSeamComponent = (MergedSeamComponent)cachedValue.getValue();
        if (mergedSeamComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/SeamJamModel", "getOrCreateMergedComponent"));
        }
        return mergedSeamComponent;
    }
}

