/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam.dataModel;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.semantic.SemKey;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Seam Data Model")
public abstract class SeamJamDataModel<T extends PsiMember & PsiNamedElement>
extends CommonModelElement.PsiBase
implements JamElement,
CommonModelElement {
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.jboss.seam.annotations.datamodel.DataModel");
    public final T myMember;
    public static final JamStringAttributeMeta.Single<String> NAME_META = JamAttributeMeta.singleString((String)"value");

    public SeamJamDataModel(T member) {
        this.myMember = member;
    }

    @Nullable
    public String getDefaultName() {
        return PropertyUtil.getPropertyName(this.myMember);
    }

    @Nullable
    public abstract PsiType getType();

    @NotNull
    public T getPsiElement() {
        T t = this.myMember;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/dataModel/SeamJamDataModel", "getPsiElement"));
        }
        return t;
    }

    @Nullable
    public String getName() {
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        return StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
    }

    @NotNull
    public JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), NAME_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/dataModel/SeamJamDataModel", "getNamedStringAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @Nullable
    public SeamComponentScope getScope() {
        return (SeamComponentScope)((Object)AnnotationModelUtil.getEnumValue((PsiAnnotation)this.getIdentifyingAnnotation(), (String)"scope", SeamComponentScope.class).getValue());
    }

    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return ANNOTATION_META.getAnnotation(this.getPsiElement());
    }

    public PomTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    public PsiTarget getAliasingPsiTarget() {
        return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

            public String getNameAlias(@Nullable String delegatePsiTargetName) {
                return SeamJamDataModel.this.getNameAlias(delegatePsiTargetName);
            }
        };
    }

    public abstract String getNameAlias(@Nullable String var1);

    public static class Field
    extends SeamJamDataModel<PsiField> {
        public static final JamMemberMeta<PsiField, Field> META = new JamFieldMeta(Field.class).addPomTargetProducer((PairConsumer)new PairConsumer<Field, Consumer<PomTarget>>(){

            public void consume(Field dataModel, Consumer<PomTarget> consumer) {
                consumer.consume((Object)dataModel.getPsiTarget());
            }
        });

        public Field(PsiField member) {
            super(member);
        }

        @Override
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        public String getNameAlias(@Nullable String delegatePsiTargetName) {
            return delegatePsiTargetName;
        }

        static {
            META.addAnnotation(ANNOTATION_META);
        }
    }

    public static class Method
    extends SeamJamDataModel<PsiMethod> {
        public static final SemKey<Method> JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("SeamJamMethod", new SemKey[0]);
        public static final JamMemberMeta<PsiMethod, Method> META = new JamMemberMeta(null, Method.class, JAM_KEY).addPomTargetProducer((PairConsumer)new PairConsumer<Method, Consumer<PomTarget>>(){

            public void consume(Method dataModel, Consumer<PomTarget> consumer) {
                consumer.consume((Object)dataModel.getPsiTarget());
            }
        });

        public Method(PsiMethod member) {
            super(member);
        }

        @Override
        public PsiType getType() {
            return ((PsiMethod)this.getPsiElement()).getReturnType();
        }

        @Override
        public String getNameAlias(@Nullable String delegatePsiTargetName) {
            return PropertyUtil.getPropertyName((String)delegatePsiTargetName);
        }

        static {
            META.addAnnotation(ANNOTATION_META);
        }
    }
}

