/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.List;
import java.util.Queue;

public class CucumberJvmSMFormatter
implements Formatter,
Reporter {
    public static final String TEAMCITY_PREFIX = "##teamcity";
    public static final int MILLION = 1000000;
    private int scenarioCount;
    private int passedScenarioCount;
    private boolean scenarioPassed = true;
    private int stepCount;
    private int passedStepCount;
    private int skippedStepCount;
    private int pendingStepCount;
    private int failedStepCount;
    private int undefinedStepCount;
    private boolean endedByNewLine = true;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = 'file:///%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]";
    private static final String TEMPLATE_SCENARIO_FAILED = "##teamcity[customProgressStatus timestamp='%s' type='testFailed']";
    private static final String TEMPLATE_TEST_PENDING = "##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_SCENARIO_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_SCENARIO_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";
    public static final String RESULT_STATUS_PENDING = "pending";
    private Appendable appendable = System.err;
    private Queue<String> queue = new ArrayDeque<String>();
    private String uri;
    private String currentFeatureName;
    private boolean beforeExampleSection;
    private ScenarioOutline currentScenarioOutline;
    private Scenario currentScenario;
    private Queue<Step> currentSteps = new ArrayDeque<Step>();

    public CucumberJvmSMFormatter(Appendable appendable) {
        this.outCommand(String.format(TEMPLATE_ENTER_THE_MATRIX, CucumberJvmSMFormatter.getCurrentTime()));
        this.outCommand(String.format(TEMPLATE_SCENARIO_COUNTING_STARTED, 0, CucumberJvmSMFormatter.getCurrentTime()));
    }

    public void feature(Feature feature) {
        if (this.currentFeatureName != null) {
            this.done();
        }
        this.currentFeatureName = "Feature: " + CucumberJvmSMFormatter.getName(feature);
        this.outCommand(String.format(TEMPLATE_TEST_SUITE_STARTED, CucumberJvmSMFormatter.getCurrentTime(), this.uri + ":" + feature.getLine(), this.currentFeatureName));
    }

    private static boolean isRealScenario(Scenario scenario) {
        return scenario.getKeyword().equals("Scenario");
    }

    public void scenario(Scenario scenario) {
        this.closeScenario();
        if (CucumberJvmSMFormatter.isRealScenario(scenario)) {
            ++this.scenarioCount;
            this.outCommand(String.format(TEMPLATE_SCENARIO_STARTED, CucumberJvmSMFormatter.getCurrentTime()));
            this.closeScenarioOutline();
            this.currentSteps.clear();
        }
        this.currentScenario = scenario;
        this.beforeExampleSection = false;
        this.outCommand(String.format(TEMPLATE_TEST_SUITE_STARTED, CucumberJvmSMFormatter.getCurrentTime(), this.uri + ":" + scenario.getLine(), CucumberJvmSMFormatter.getName(this.currentScenario)));
        while (this.queue.size() > 0) {
            String smMessage = this.queue.poll();
            this.outCommand(smMessage);
        }
    }

    public void scenarioOutline(ScenarioOutline outline) {
        ++this.scenarioCount;
        this.outCommand(String.format(TEMPLATE_SCENARIO_STARTED, CucumberJvmSMFormatter.getCurrentTime()));
        this.queue.clear();
        this.currentSteps.clear();
        this.closePreviousScenarios();
        this.currentScenarioOutline = outline;
        this.currentScenario = null;
        this.beforeExampleSection = true;
        this.outCommand(String.format(TEMPLATE_TEST_SUITE_STARTED, CucumberJvmSMFormatter.getCurrentTime(), this.uri + ":" + outline.getLine(), CucumberJvmSMFormatter.getName(this.currentScenarioOutline)));
    }

    public void examples(Examples examples) {
        this.beforeExampleSection = false;
        this.outCommand(String.format(TEMPLATE_TEST_SUITE_STARTED, CucumberJvmSMFormatter.getCurrentTime(), this.uri + ":" + examples.getLine(), "Examples:"));
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    public void step(Step step) {
        if (this.beforeExampleSection) {
            return;
        }
        this.currentSteps.add(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    public void result(Result result) {
        ++this.stepCount;
        Step currentStep = this.currentSteps.poll();
        this.outCommand(String.format(TEMPLATE_TEST_STARTED, CucumberJvmSMFormatter.getCurrentTime(), this.uri + ":" + currentStep.getLine(), CucumberJvmSMFormatter.getName(currentStep)), true);
        String stepFullName = CucumberJvmSMFormatter.getName(currentStep);
        if (result.getStatus().equals("failed")) {
            String details;
            String message;
            ++this.failedStepCount;
            this.scenarioPassed = false;
            String fullMessage = result.getErrorMessage().replace("\r", "").replace("\t", "  ");
            String[] messageInfo = fullMessage.split("\n", 2);
            if (messageInfo.length == 2) {
                message = messageInfo[0].trim();
                details = messageInfo[1].trim();
            } else {
                message = fullMessage;
                details = "";
            }
            this.outCommand(String.format(TEMPLATE_TEST_FAILED, CucumberJvmSMFormatter.getCurrentTime(), CucumberJvmSMFormatter.escape(details), CucumberJvmSMFormatter.escape(message), stepFullName, ""), true);
        } else if (result.getStatus().equals(RESULT_STATUS_PENDING)) {
            ++this.pendingStepCount;
            this.scenarioPassed = false;
            this.outCommand(String.format(TEMPLATE_TEST_PENDING, stepFullName, CucumberJvmSMFormatter.getCurrentTime()), true);
        } else if (result.equals(Result.UNDEFINED)) {
            ++this.undefinedStepCount;
            this.scenarioPassed = false;
            String message = "Undefined step: " + CucumberJvmSMFormatter.getName(currentStep);
            String details = "";
            this.outCommand(String.format(TEMPLATE_TEST_FAILED, CucumberJvmSMFormatter.getCurrentTime(), CucumberJvmSMFormatter.escape(details), CucumberJvmSMFormatter.escape(message), stepFullName, "error = 'true'"), true);
        } else if (result.equals(Result.SKIPPED)) {
            ++this.skippedStepCount;
            this.scenarioPassed = false;
            this.outCommand(String.format(TEMPLATE_TEST_PENDING, stepFullName, CucumberJvmSMFormatter.getCurrentTime()), true);
        } else {
            ++this.passedStepCount;
        }
        String currentTime = CucumberJvmSMFormatter.getCurrentTime();
        Long duration = result.getDuration();
        this.outCommand(String.format(TEMPLATE_TEST_FINISHED, currentTime, (duration == null ? 0L : duration) / 1000000L, stepFullName), true);
    }

    private void closeScenario() {
        if (this.currentScenario != null) {
            if (CucumberJvmSMFormatter.isRealScenario(this.currentScenario) && this.scenarioPassed) {
                ++this.passedScenarioCount;
            }
            if (!this.scenarioPassed) {
                this.outCommand(String.format(TEMPLATE_SCENARIO_FAILED, CucumberJvmSMFormatter.getCurrentTime()), true);
            }
            this.outCommand(String.format(TEMPLATE_SCENARIO_FINISHED, CucumberJvmSMFormatter.getCurrentTime()), true);
            this.outCommand(String.format(TEMPLATE_TEST_SUITE_FINISHED, CucumberJvmSMFormatter.getCurrentTime(), CucumberJvmSMFormatter.getName(this.currentScenario)));
        }
        this.scenarioPassed = true;
        this.currentScenario = null;
    }

    private void closeScenarioOutline() {
        if (this.currentScenarioOutline != null) {
            if (this.scenarioPassed) {
                ++this.passedScenarioCount;
            }
            if (!this.beforeExampleSection) {
                this.outCommand(String.format(TEMPLATE_TEST_SUITE_FINISHED, CucumberJvmSMFormatter.getCurrentTime(), "Examples:"));
            }
            this.outCommand(String.format(TEMPLATE_TEST_SUITE_FINISHED, CucumberJvmSMFormatter.getCurrentTime(), CucumberJvmSMFormatter.getName(this.currentScenarioOutline)));
        }
        this.currentScenarioOutline = null;
    }

    private void closePreviousScenarios() {
        this.closeScenario();
        this.closeScenarioOutline();
    }

    public void background(Background background) {
        this.closeScenario();
        this.currentScenario = null;
    }

    public void done() {
        this.closePreviousScenarios();
        this.outCommand(String.format(TEMPLATE_TEST_SUITE_FINISHED, CucumberJvmSMFormatter.getCurrentTime(), this.currentFeatureName));
    }

    public void uri(String s) {
        String currentDir = System.getProperty("org.jetbrains.run.directory");
        this.uri = currentDir != null ? currentDir + File.separator + s : s;
    }

    public void eof() {
    }

    public void syntaxError(String s, String s1, List<String> strings, String s2, Integer integer) {
        this.outCommand("Syntax error\n");
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
        this.outCommand("embedding\n");
    }

    public void embedding(String s, InputStream inputStream) {
        this.outCommand("embedding\n");
    }

    public void write(String s) {
        this.out(s);
    }

    public void close() {
        this.outCommand(String.format(TEMPLATE_SCENARIO_COUNTING_FINISHED, CucumberJvmSMFormatter.getCurrentTime()));
    }

    public void before(Match match, Result result) {
    }

    private static String getCurrentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private static String escape(String source) {
        return source.replace("|", "||").replace("\n", "|n").replace("\r", "|r").replace("'", "|'").replace("[", "|[").replace("]", "|]");
    }

    private void outCommand(String s) {
        this.outCommand(s, false);
    }

    private void outCommand(String s, boolean waitForScenario) {
        if (this.currentScenario == null && waitForScenario) {
            this.queue.add(s);
        } else {
            try {
                if (!this.endedByNewLine) {
                    this.appendable.append("\n");
                }
                this.appendable.append(s);
                this.appendable.append("\n");
                this.endedByNewLine = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void out(String s) {
        try {
            this.appendable.append(s);
            this.endedByNewLine = s.endsWith("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getName(Scenario scenario) {
        if (scenario.getKeyword().equals("Scenario Outline")) {
            return CucumberJvmSMFormatter.escape("Scenario: Line: " + scenario.getLine());
        }
        return CucumberJvmSMFormatter.escape("Scenario: " + scenario.getName());
    }

    private static String getName(ScenarioOutline outline) {
        return CucumberJvmSMFormatter.escape("Scenario Outline: " + outline.getName());
    }

    private static String getName(Step step) {
        return CucumberJvmSMFormatter.escape(step.getKeyword() + " " + step.getName());
    }

    private static String getName(Feature feature) {
        return CucumberJvmSMFormatter.escape(feature.getName());
    }
}

